/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AMQConnection;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.Frame;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.FrameHandler;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.SocketChannelFrameHandlerState;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;

public class SocketChannelFrameHandler
implements FrameHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketChannelFrameHandler.class);
    private final SocketChannelFrameHandlerState state;

    public SocketChannelFrameHandler(SocketChannelFrameHandlerState socketChannelFrameHandlerState) {
        this.state = socketChannelFrameHandlerState;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.state.getChannel().socket().getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.state.getChannel().socket().getLocalPort();
    }

    @Override
    public InetAddress getAddress() {
        return this.state.getChannel().socket().getInetAddress();
    }

    @Override
    public int getPort() {
        return this.state.getChannel().socket().getPort();
    }

    @Override
    public void setTimeout(int n2) throws SocketException {
        this.state.getChannel().socket().setSoTimeout(n2);
    }

    @Override
    public int getTimeout() throws SocketException {
        return this.state.getChannel().socket().getSoTimeout();
    }

    @Override
    public void sendHeader() throws IOException {
        this.state.sendHeader();
    }

    @Override
    public void initialize(AMQConnection aMQConnection) {
        this.state.setConnection(aMQConnection);
    }

    @Override
    public Frame readFrame() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeFrame(Frame frame) throws IOException {
        this.state.write(frame);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() {
        try {
            this.state.close();
        }
        catch (IOException iOException) {
            LOGGER.warn("Error while closing SocketChannel", iOException);
        }
    }

    public SocketChannelFrameHandlerState getState() {
        return this.state;
    }
}

