/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio;

import com.contrastsecurity.thirdparty.com.rabbitmq.client.Address;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ConnectionContext;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ConnectionFactory;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.ConnectionPostProcessor;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.AbstractFrameHandlerFactory;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.FrameHandler;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.NioLoopContext;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.NioParams;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.SocketChannelFrameHandler;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.SocketChannelFrameHandlerState;
import com.contrastsecurity.thirdparty.com.rabbitmq.client.impl.nio.SslEngineHelper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;

public class SocketChannelFrameHandlerFactory
extends AbstractFrameHandlerFactory {
    final NioParams nioParams;
    private final SSLContext sslContext;
    private final Lock stateLock = new ReentrantLock();
    private final AtomicLong globalConnectionCount = new AtomicLong();
    private final List<NioLoopContext> nioLoopContexts;

    public SocketChannelFrameHandlerFactory(int n2, NioParams nioParams, boolean bl2, SSLContext sSLContext, ConnectionPostProcessor connectionPostProcessor) {
        super(n2, null, bl2, connectionPostProcessor);
        this.nioParams = new NioParams(nioParams);
        this.sslContext = sSLContext;
        this.nioLoopContexts = new ArrayList<NioLoopContext>(this.nioParams.getNbIoThreads());
        for (int i2 = 0; i2 < this.nioParams.getNbIoThreads(); ++i2) {
            this.nioLoopContexts.add(new NioLoopContext(this, this.nioParams));
        }
    }

    public SocketChannelFrameHandlerFactory(int n2, NioParams nioParams, boolean bl2, SSLContext sSLContext) {
        this(n2, nioParams, bl2, sSLContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FrameHandler create(Address address) throws IOException {
        int n2 = ConnectionFactory.portOrDefault(address.getPort(), this.ssl);
        SSLEngine sSLEngine = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        if (this.ssl) {
            sSLEngine = this.sslContext.createSSLEngine(address.getHost(), n2);
            sSLEngine.setUseClientMode(true);
            if (this.nioParams.getSslEngineConfigurator() != null) {
                this.nioParams.getSslEngineConfigurator().configure(sSLEngine);
            }
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(address.getHost(), n2);
        abstractInterruptibleChannel = SocketChannel.open();
        ((AbstractSelectableChannel)abstractInterruptibleChannel).configureBlocking(true);
        if (this.nioParams.getSocketChannelConfigurator() != null) {
            this.nioParams.getSocketChannelConfigurator().configure((SocketChannel)abstractInterruptibleChannel);
        }
        ((SocketChannel)abstractInterruptibleChannel).connect(inetSocketAddress);
        if (this.ssl) {
            sSLEngine.beginHandshake();
            boolean bl2 = SslEngineHelper.doHandshake((SocketChannel)abstractInterruptibleChannel, sSLEngine);
            if (!bl2) {
                throw new SSLException("TLS handshake failed");
            }
        }
        this.connectionPostProcessor.postProcess(new ConnectionContext(((SocketChannel)abstractInterruptibleChannel).socket(), address, this.ssl, sSLEngine == null ? null : sSLEngine.getSession()));
        ((AbstractSelectableChannel)abstractInterruptibleChannel).configureBlocking(false);
        this.stateLock.lock();
        NioLoopContext nioLoopContext = null;
        try {
            SocketChannelFrameHandler socketChannelFrameHandler;
            long l2 = this.globalConnectionCount.getAndIncrement() % (long)this.nioParams.getNbIoThreads();
            nioLoopContext = this.nioLoopContexts.get((int)l2);
            nioLoopContext.initStateIfNecessary();
            SocketChannelFrameHandlerState socketChannelFrameHandlerState = new SocketChannelFrameHandlerState((SocketChannel)abstractInterruptibleChannel, nioLoopContext, this.nioParams, sSLEngine);
            socketChannelFrameHandlerState.startReading();
            SocketChannelFrameHandler socketChannelFrameHandler2 = socketChannelFrameHandler = new SocketChannelFrameHandler(socketChannelFrameHandlerState);
            this.stateLock.unlock();
            return socketChannelFrameHandler2;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.unlock();
                throw throwable;
            }
            catch (IOException iOException) {
                try {
                    if (sSLEngine != null && abstractInterruptibleChannel != null) {
                        SslEngineHelper.close((WritableByteChannel)((Object)abstractInterruptibleChannel), sSLEngine);
                    }
                    abstractInterruptibleChannel.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw iOException;
            }
        }
    }

    void lock() {
        this.stateLock.lock();
    }

    void unlock() {
        this.stateLock.unlock();
    }
}

