/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dagger.internal;

import com.contrastsecurity.thirdparty.dagger.internal.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class SetBuilder<T> {
    private static final String SET_CONTRIBUTIONS_CANNOT_BE_NULL = "Set contributions cannot be null";
    private final List<T> contributions;

    private SetBuilder(int n2) {
        this.contributions = new ArrayList<T>(n2);
    }

    public static <T> SetBuilder<T> newSetBuilder(int n2) {
        return new SetBuilder<T>(n2);
    }

    public SetBuilder<T> add(T t2) {
        this.contributions.add(Preconditions.checkNotNull(t2, SET_CONTRIBUTIONS_CANNOT_BE_NULL));
        return this;
    }

    public SetBuilder<T> addAll(Collection<? extends T> collection) {
        for (T t2 : collection) {
            Preconditions.checkNotNull(t2, SET_CONTRIBUTIONS_CANNOT_BE_NULL);
        }
        this.contributions.addAll(collection);
        return this;
    }

    public Set<T> build() {
        if (this.contributions.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.contributions.size() == 1) {
            return Collections.singleton(this.contributions.get(0));
        }
        return Collections.unmodifiableSet(new HashSet<T>(this.contributions));
    }
}

