/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dev.failsafe;

import com.contrastsecurity.thirdparty.dev.failsafe.PolicyBuilder;
import com.contrastsecurity.thirdparty.dev.failsafe.RateLimiter;
import com.contrastsecurity.thirdparty.dev.failsafe.RateLimiterConfig;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.RateLimiterImpl;
import com.contrastsecurity.thirdparty.dev.failsafe.internal.util.Assert;
import java.time.Duration;

public class RateLimiterBuilder<R>
extends PolicyBuilder<RateLimiterBuilder<R>, RateLimiterConfig<R>, R> {
    RateLimiterBuilder(Duration duration) {
        super(new RateLimiterConfig(duration));
        ((RateLimiterConfig)this.config).maxWaitTime = Duration.ZERO;
    }

    RateLimiterBuilder(long l2, Duration duration) {
        super(new RateLimiterConfig(l2, duration));
        ((RateLimiterConfig)this.config).maxWaitTime = Duration.ZERO;
    }

    RateLimiterBuilder(RateLimiterConfig<R> rateLimiterConfig) {
        super(new RateLimiterConfig<R>(rateLimiterConfig));
    }

    public RateLimiter<R> build() {
        return new RateLimiterImpl(new RateLimiterConfig((RateLimiterConfig)this.config));
    }

    public RateLimiterBuilder<R> withMaxWaitTime(Duration duration) {
        ((RateLimiterConfig)this.config).maxWaitTime = Assert.notNull(duration, "maxWaitTime");
        return this;
    }
}

