/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dk.brics.automaton;

import com.contrastsecurity.thirdparty.dk.brics.automaton.RunAutomaton;
import java.util.regex.MatchResult;

public class AutomatonMatcher
implements MatchResult {
    private final RunAutomaton automaton;
    private final CharSequence chars;
    private int matchStart = -1;
    private int matchEnd = -1;

    AutomatonMatcher(CharSequence charSequence, RunAutomaton runAutomaton) {
        this.chars = charSequence;
        this.automaton = runAutomaton;
    }

    public boolean find() {
        int n2;
        int n3;
        int n4;
        switch (this.getMatchStart()) {
            case -2: {
                return false;
            }
            case -1: {
                n4 = 0;
                break;
            }
            default: {
                n4 = this.getMatchEnd();
                if (n4 != this.getMatchStart() || ++n4 <= this.getChars().length()) break;
                this.setMatch(-2, -2);
                return false;
            }
        }
        if (this.automaton.isAccept(this.automaton.getInitialState())) {
            n3 = n4;
            n2 = n4;
        } else {
            n3 = -1;
            n2 = -1;
        }
        int n5 = this.getChars().length();
        while (n4 < n5) {
            int n6;
            int n7 = this.automaton.getInitialState();
            for (int i2 = n4; i2 < n5 && (n6 = this.automaton.step(n7, this.getChars().charAt(i2))) != -1; ++i2) {
                if (this.automaton.isAccept(n6)) {
                    n3 = n4;
                    n2 = i2 + 1;
                }
                n7 = n6;
            }
            if (n3 != -1) {
                this.setMatch(n3, n2);
                return true;
            }
            ++n4;
        }
        if (n3 != -1) {
            this.setMatch(n3, n2);
            return true;
        }
        this.setMatch(-2, -2);
        return false;
    }

    private void setMatch(int n2, int n3) throws IllegalArgumentException {
        if (n2 > n3) {
            throw new IllegalArgumentException("Start must be less than or equal to end: " + n2 + ", " + n3);
        }
        this.matchStart = n2;
        this.matchEnd = n3;
    }

    private int getMatchStart() {
        return this.matchStart;
    }

    private int getMatchEnd() {
        return this.matchEnd;
    }

    private CharSequence getChars() {
        return this.chars;
    }

    @Override
    public int end() throws IllegalStateException {
        this.matchGood();
        return this.matchEnd;
    }

    @Override
    public int end(int n2) throws IndexOutOfBoundsException, IllegalStateException {
        AutomatonMatcher.onlyZero(n2);
        return this.end();
    }

    @Override
    public String group() throws IllegalStateException {
        this.matchGood();
        return this.chars.subSequence(this.matchStart, this.matchEnd).toString();
    }

    @Override
    public String group(int n2) throws IndexOutOfBoundsException, IllegalStateException {
        AutomatonMatcher.onlyZero(n2);
        return this.group();
    }

    @Override
    public int groupCount() {
        return 0;
    }

    @Override
    public int start() throws IllegalStateException {
        this.matchGood();
        return this.matchStart;
    }

    @Override
    public int start(int n2) throws IndexOutOfBoundsException, IllegalStateException {
        AutomatonMatcher.onlyZero(n2);
        return this.start();
    }

    public MatchResult toMatchResult() {
        AutomatonMatcher automatonMatcher = new AutomatonMatcher(this.chars, this.automaton);
        automatonMatcher.matchStart = this.matchStart;
        automatonMatcher.matchEnd = this.matchEnd;
        return automatonMatcher;
    }

    private static void onlyZero(int n2) throws IndexOutOfBoundsException {
        if (n2 != 0) {
            throw new IndexOutOfBoundsException("The only group supported is 0.");
        }
    }

    private void matchGood() throws IllegalStateException {
        if (this.matchStart < 0 || this.matchEnd < 0) {
            throw new IllegalStateException("There was no available match.");
        }
    }
}

