/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.dk.brics.automaton;

import com.contrastsecurity.thirdparty.dk.brics.automaton.Automaton;
import com.contrastsecurity.thirdparty.dk.brics.automaton.AutomatonProvider;
import com.contrastsecurity.thirdparty.dk.brics.automaton.BasicAutomata;
import com.contrastsecurity.thirdparty.dk.brics.automaton.BasicOperations;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RegExp {
    public static final int INTERSECTION = 1;
    public static final int COMPLEMENT = 2;
    public static final int EMPTY = 4;
    public static final int ANYSTRING = 8;
    public static final int AUTOMATON = 16;
    public static final int INTERVAL = 32;
    public static final int QUOTED_STRING = 64;
    public static final int ALL = 65535;
    public static final int NONE = 0;
    private static boolean allow_mutation = false;
    Kind kind;
    RegExp exp1;
    RegExp exp2;
    String s;
    char c;
    int min;
    int max;
    int digits;
    char from;
    char to;
    String b;
    int flags;
    int pos;

    RegExp() {
    }

    public RegExp(String string) throws IllegalArgumentException {
        this(string, 65535);
    }

    public RegExp(String string, int n2) throws IllegalArgumentException {
        RegExp regExp;
        this.b = string;
        this.flags = n2;
        if (string.length() == 0) {
            regExp = RegExp.makeString("");
        } else {
            regExp = this.parseUnionExp();
            if (this.pos < this.b.length()) {
                throw new IllegalArgumentException("end-of-string expected at position " + this.pos);
            }
        }
        this.kind = regExp.kind;
        this.exp1 = regExp.exp1;
        this.exp2 = regExp.exp2;
        this.s = regExp.s;
        this.c = regExp.c;
        this.min = regExp.min;
        this.max = regExp.max;
        this.digits = regExp.digits;
        this.from = regExp.from;
        this.to = regExp.to;
        this.b = null;
    }

    public Automaton toAutomaton() {
        return this.toAutomatonAllowMutate(null, null, true);
    }

    public Automaton toAutomaton(boolean bl2) {
        return this.toAutomatonAllowMutate(null, null, bl2);
    }

    public Automaton toAutomaton(AutomatonProvider automatonProvider) throws IllegalArgumentException {
        return this.toAutomatonAllowMutate(null, automatonProvider, true);
    }

    public Automaton toAutomaton(AutomatonProvider automatonProvider, boolean bl2) throws IllegalArgumentException {
        return this.toAutomatonAllowMutate(null, automatonProvider, bl2);
    }

    public Automaton toAutomaton(Map<String, Automaton> map) throws IllegalArgumentException {
        return this.toAutomatonAllowMutate(map, null, true);
    }

    public Automaton toAutomaton(Map<String, Automaton> map, boolean bl2) throws IllegalArgumentException {
        return this.toAutomatonAllowMutate(map, null, bl2);
    }

    public boolean setAllowMutate(boolean bl2) {
        boolean bl3 = allow_mutation;
        allow_mutation = bl2;
        return bl3;
    }

    private Automaton toAutomatonAllowMutate(Map<String, Automaton> map, AutomatonProvider automatonProvider, boolean bl2) throws IllegalArgumentException {
        boolean bl3 = false;
        if (allow_mutation) {
            bl3 = Automaton.setAllowMutate(true);
        }
        Automaton automaton = this.toAutomaton(map, automatonProvider, bl2);
        if (allow_mutation) {
            Automaton.setAllowMutate(bl3);
        }
        return automaton;
    }

    private Automaton toAutomaton(Map<String, Automaton> map, AutomatonProvider automatonProvider, boolean bl2) throws IllegalArgumentException {
        Automaton automaton = null;
        switch (this.kind) {
            case REGEXP_UNION: {
                ArrayList<Automaton> arrayList = new ArrayList<Automaton>();
                this.findLeaves(this.exp1, Kind.REGEXP_UNION, arrayList, map, automatonProvider, bl2);
                this.findLeaves(this.exp2, Kind.REGEXP_UNION, arrayList, map, automatonProvider, bl2);
                automaton = BasicOperations.union(arrayList);
                if (!bl2) break;
                automaton.minimize();
                break;
            }
            case REGEXP_CONCATENATION: {
                ArrayList<Automaton> arrayList = new ArrayList<Automaton>();
                this.findLeaves(this.exp1, Kind.REGEXP_CONCATENATION, arrayList, map, automatonProvider, bl2);
                this.findLeaves(this.exp2, Kind.REGEXP_CONCATENATION, arrayList, map, automatonProvider, bl2);
                automaton = BasicOperations.concatenate(arrayList);
                if (!bl2) break;
                automaton.minimize();
                break;
            }
            case REGEXP_INTERSECTION: {
                automaton = this.exp1.toAutomaton(map, automatonProvider, bl2).intersection(this.exp2.toAutomaton(map, automatonProvider, bl2));
                if (!bl2) break;
                automaton.minimize();
                break;
            }
            case REGEXP_OPTIONAL: {
                automaton = this.exp1.toAutomaton(map, automatonProvider, bl2).optional();
                if (!bl2) break;
                automaton.minimize();
                break;
            }
            case REGEXP_REPEAT: {
                automaton = this.exp1.toAutomaton(map, automatonProvider, bl2).repeat();
                if (!bl2) break;
                automaton.minimize();
                break;
            }
            case REGEXP_REPEAT_MIN: {
                automaton = this.exp1.toAutomaton(map, automatonProvider, bl2).repeat(this.min);
                if (!bl2) break;
                automaton.minimize();
                break;
            }
            case REGEXP_REPEAT_MINMAX: {
                automaton = this.exp1.toAutomaton(map, automatonProvider, bl2).repeat(this.min, this.max);
                if (!bl2) break;
                automaton.minimize();
                break;
            }
            case REGEXP_COMPLEMENT: {
                automaton = this.exp1.toAutomaton(map, automatonProvider, bl2).complement();
                if (!bl2) break;
                automaton.minimize();
                break;
            }
            case REGEXP_CHAR: {
                automaton = BasicAutomata.makeChar(this.c);
                break;
            }
            case REGEXP_CHAR_RANGE: {
                automaton = BasicAutomata.makeCharRange(this.from, this.to);
                break;
            }
            case REGEXP_ANYCHAR: {
                automaton = BasicAutomata.makeAnyChar();
                break;
            }
            case REGEXP_EMPTY: {
                automaton = BasicAutomata.makeEmpty();
                break;
            }
            case REGEXP_STRING: {
                automaton = BasicAutomata.makeString(this.s);
                break;
            }
            case REGEXP_ANYSTRING: {
                automaton = BasicAutomata.makeAnyString();
                break;
            }
            case REGEXP_AUTOMATON: {
                Automaton automaton2 = null;
                if (map != null) {
                    automaton2 = map.get(this.s);
                }
                if (automaton2 == null && automatonProvider != null) {
                    try {
                        automaton2 = automatonProvider.getAutomaton(this.s);
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException(iOException);
                    }
                }
                if (automaton2 == null) {
                    throw new IllegalArgumentException("'" + this.s + "' not found");
                }
                automaton = automaton2.clone();
                break;
            }
            case REGEXP_INTERVAL: {
                automaton = BasicAutomata.makeInterval(this.min, this.max, this.digits);
            }
        }
        return automaton;
    }

    private void findLeaves(RegExp regExp, Kind kind, List<Automaton> list, Map<String, Automaton> map, AutomatonProvider automatonProvider, boolean bl2) {
        if (regExp.kind == kind) {
            this.findLeaves(regExp.exp1, kind, list, map, automatonProvider, bl2);
            this.findLeaves(regExp.exp2, kind, list, map, automatonProvider, bl2);
        } else {
            list.add(regExp.toAutomaton(map, automatonProvider, bl2));
        }
    }

    public String toString() {
        return this.toStringBuilder(new StringBuilder()).toString();
    }

    StringBuilder toStringBuilder(StringBuilder stringBuilder) {
        switch (this.kind) {
            case REGEXP_UNION: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append("|");
                this.exp2.toStringBuilder(stringBuilder);
                stringBuilder.append(")");
                break;
            }
            case REGEXP_CONCATENATION: {
                this.exp1.toStringBuilder(stringBuilder);
                this.exp2.toStringBuilder(stringBuilder);
                break;
            }
            case REGEXP_INTERSECTION: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append("&");
                this.exp2.toStringBuilder(stringBuilder);
                stringBuilder.append(")");
                break;
            }
            case REGEXP_OPTIONAL: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append(")?");
                break;
            }
            case REGEXP_REPEAT: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append(")*");
                break;
            }
            case REGEXP_REPEAT_MIN: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append("){").append(this.min).append(",}");
                break;
            }
            case REGEXP_REPEAT_MINMAX: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append("){").append(this.min).append(",").append(this.max).append("}");
                break;
            }
            case REGEXP_COMPLEMENT: {
                stringBuilder.append("~(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append(")");
                break;
            }
            case REGEXP_CHAR: {
                this.appendChar(this.c, stringBuilder);
                break;
            }
            case REGEXP_CHAR_RANGE: {
                stringBuilder.append("[\\").append(this.from).append("-\\").append(this.to).append("]");
                break;
            }
            case REGEXP_ANYCHAR: {
                stringBuilder.append(".");
                break;
            }
            case REGEXP_EMPTY: {
                stringBuilder.append("#");
                break;
            }
            case REGEXP_STRING: {
                if (this.s.indexOf(34) == -1) {
                    stringBuilder.append("\"").append(this.s).append("\"");
                    break;
                }
                for (int i2 = 0; i2 < this.s.length(); ++i2) {
                    this.appendChar(this.s.charAt(i2), stringBuilder);
                }
                break;
            }
            case REGEXP_ANYSTRING: {
                stringBuilder.append("@");
                break;
            }
            case REGEXP_AUTOMATON: {
                stringBuilder.append("<").append(this.s).append(">");
                break;
            }
            case REGEXP_INTERVAL: {
                int n2;
                String string = Integer.toString(this.min);
                String string2 = Integer.toString(this.max);
                stringBuilder.append("<");
                if (this.digits > 0) {
                    for (n2 = string.length(); n2 < this.digits; ++n2) {
                        stringBuilder.append('0');
                    }
                }
                stringBuilder.append(string).append("-");
                if (this.digits > 0) {
                    for (n2 = string2.length(); n2 < this.digits; ++n2) {
                        stringBuilder.append('0');
                    }
                }
                stringBuilder.append(string2).append(">");
            }
        }
        return stringBuilder;
    }

    private void appendChar(char c2, StringBuilder stringBuilder) {
        if ("|&?*+{},![]^-.#@\"()<>\\".indexOf(c2) != -1) {
            stringBuilder.append("\\");
        }
        stringBuilder.append(c2);
    }

    public Set<String> getIdentifiers() {
        HashSet<String> hashSet = new HashSet<String>();
        this.getIdentifiers(hashSet);
        return hashSet;
    }

    void getIdentifiers(Set<String> set) {
        switch (this.kind) {
            case REGEXP_UNION: 
            case REGEXP_CONCATENATION: 
            case REGEXP_INTERSECTION: {
                this.exp1.getIdentifiers(set);
                this.exp2.getIdentifiers(set);
                break;
            }
            case REGEXP_OPTIONAL: 
            case REGEXP_REPEAT: 
            case REGEXP_REPEAT_MIN: 
            case REGEXP_REPEAT_MINMAX: 
            case REGEXP_COMPLEMENT: {
                this.exp1.getIdentifiers(set);
                break;
            }
            case REGEXP_AUTOMATON: {
                set.add(this.s);
                break;
            }
        }
    }

    static RegExp makeUnion(RegExp regExp, RegExp regExp2) {
        RegExp regExp3 = new RegExp();
        regExp3.kind = Kind.REGEXP_UNION;
        regExp3.exp1 = regExp;
        regExp3.exp2 = regExp2;
        return regExp3;
    }

    static RegExp makeConcatenation(RegExp regExp, RegExp regExp2) {
        if (!(regExp.kind != Kind.REGEXP_CHAR && regExp.kind != Kind.REGEXP_STRING || regExp2.kind != Kind.REGEXP_CHAR && regExp2.kind != Kind.REGEXP_STRING)) {
            return RegExp.makeString(regExp, regExp2);
        }
        RegExp regExp3 = new RegExp();
        regExp3.kind = Kind.REGEXP_CONCATENATION;
        if (!(regExp.kind != Kind.REGEXP_CONCATENATION || regExp.exp2.kind != Kind.REGEXP_CHAR && regExp.exp2.kind != Kind.REGEXP_STRING || regExp2.kind != Kind.REGEXP_CHAR && regExp2.kind != Kind.REGEXP_STRING)) {
            regExp3.exp1 = regExp.exp1;
            regExp3.exp2 = RegExp.makeString(regExp.exp2, regExp2);
        } else if (!(regExp.kind != Kind.REGEXP_CHAR && regExp.kind != Kind.REGEXP_STRING || regExp2.kind != Kind.REGEXP_CONCATENATION || regExp2.exp1.kind != Kind.REGEXP_CHAR && regExp2.exp1.kind != Kind.REGEXP_STRING)) {
            regExp3.exp1 = RegExp.makeString(regExp, regExp2.exp1);
            regExp3.exp2 = regExp2.exp2;
        } else {
            regExp3.exp1 = regExp;
            regExp3.exp2 = regExp2;
        }
        return regExp3;
    }

    private static RegExp makeString(RegExp regExp, RegExp regExp2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (regExp.kind == Kind.REGEXP_STRING) {
            stringBuilder.append(regExp.s);
        } else {
            stringBuilder.append(regExp.c);
        }
        if (regExp2.kind == Kind.REGEXP_STRING) {
            stringBuilder.append(regExp2.s);
        } else {
            stringBuilder.append(regExp2.c);
        }
        return RegExp.makeString(stringBuilder.toString());
    }

    static RegExp makeIntersection(RegExp regExp, RegExp regExp2) {
        RegExp regExp3 = new RegExp();
        regExp3.kind = Kind.REGEXP_INTERSECTION;
        regExp3.exp1 = regExp;
        regExp3.exp2 = regExp2;
        return regExp3;
    }

    static RegExp makeOptional(RegExp regExp) {
        RegExp regExp2 = new RegExp();
        regExp2.kind = Kind.REGEXP_OPTIONAL;
        regExp2.exp1 = regExp;
        return regExp2;
    }

    static RegExp makeRepeat(RegExp regExp) {
        RegExp regExp2 = new RegExp();
        regExp2.kind = Kind.REGEXP_REPEAT;
        regExp2.exp1 = regExp;
        return regExp2;
    }

    static RegExp makeRepeat(RegExp regExp, int n2) {
        RegExp regExp2 = new RegExp();
        regExp2.kind = Kind.REGEXP_REPEAT_MIN;
        regExp2.exp1 = regExp;
        regExp2.min = n2;
        return regExp2;
    }

    static RegExp makeRepeat(RegExp regExp, int n2, int n3) {
        RegExp regExp2 = new RegExp();
        regExp2.kind = Kind.REGEXP_REPEAT_MINMAX;
        regExp2.exp1 = regExp;
        regExp2.min = n2;
        regExp2.max = n3;
        return regExp2;
    }

    static RegExp makeComplement(RegExp regExp) {
        RegExp regExp2 = new RegExp();
        regExp2.kind = Kind.REGEXP_COMPLEMENT;
        regExp2.exp1 = regExp;
        return regExp2;
    }

    static RegExp makeChar(char c2) {
        RegExp regExp = new RegExp();
        regExp.kind = Kind.REGEXP_CHAR;
        regExp.c = c2;
        return regExp;
    }

    static RegExp makeCharRange(char c2, char c3) {
        RegExp regExp = new RegExp();
        regExp.kind = Kind.REGEXP_CHAR_RANGE;
        regExp.from = c2;
        regExp.to = c3;
        return regExp;
    }

    static RegExp makeAnyChar() {
        RegExp regExp = new RegExp();
        regExp.kind = Kind.REGEXP_ANYCHAR;
        return regExp;
    }

    static RegExp makeEmpty() {
        RegExp regExp = new RegExp();
        regExp.kind = Kind.REGEXP_EMPTY;
        return regExp;
    }

    static RegExp makeString(String string) {
        RegExp regExp = new RegExp();
        regExp.kind = Kind.REGEXP_STRING;
        regExp.s = string;
        return regExp;
    }

    static RegExp makeAnyString() {
        RegExp regExp = new RegExp();
        regExp.kind = Kind.REGEXP_ANYSTRING;
        return regExp;
    }

    static RegExp makeAutomaton(String string) {
        RegExp regExp = new RegExp();
        regExp.kind = Kind.REGEXP_AUTOMATON;
        regExp.s = string;
        return regExp;
    }

    static RegExp makeInterval(int n2, int n3, int n4) {
        RegExp regExp = new RegExp();
        regExp.kind = Kind.REGEXP_INTERVAL;
        regExp.min = n2;
        regExp.max = n3;
        regExp.digits = n4;
        return regExp;
    }

    private boolean peek(String string) {
        return this.more() && string.indexOf(this.b.charAt(this.pos)) != -1;
    }

    private boolean match(char c2) {
        if (this.pos >= this.b.length()) {
            return false;
        }
        if (this.b.charAt(this.pos) == c2) {
            ++this.pos;
            return true;
        }
        return false;
    }

    private boolean more() {
        return this.pos < this.b.length();
    }

    private char next() throws IllegalArgumentException {
        if (!this.more()) {
            throw new IllegalArgumentException("unexpected end-of-string");
        }
        return this.b.charAt(this.pos++);
    }

    private boolean check(int n2) {
        return (this.flags & n2) != 0;
    }

    final RegExp parseUnionExp() throws IllegalArgumentException {
        RegExp regExp = this.parseInterExp();
        if (this.match('|')) {
            regExp = RegExp.makeUnion(regExp, this.parseUnionExp());
        }
        return regExp;
    }

    final RegExp parseInterExp() throws IllegalArgumentException {
        RegExp regExp = this.parseConcatExp();
        if (this.check(1) && this.match('&')) {
            regExp = RegExp.makeIntersection(regExp, this.parseInterExp());
        }
        return regExp;
    }

    final RegExp parseConcatExp() throws IllegalArgumentException {
        RegExp regExp = this.parseRepeatExp();
        if (!(!this.more() || this.peek(")|") || this.check(1) && this.peek("&"))) {
            regExp = RegExp.makeConcatenation(regExp, this.parseConcatExp());
        }
        return regExp;
    }

    final RegExp parseRepeatExp() throws IllegalArgumentException {
        RegExp regExp = this.parseComplExp();
        while (this.peek("?*+{")) {
            if (this.match('?')) {
                regExp = RegExp.makeOptional(regExp);
                continue;
            }
            if (this.match('*')) {
                regExp = RegExp.makeRepeat(regExp);
                continue;
            }
            if (this.match('+')) {
                regExp = RegExp.makeRepeat(regExp, 1);
                continue;
            }
            if (!this.match('{')) continue;
            int n2 = this.pos;
            while (this.peek("0123456789")) {
                this.next();
            }
            if (n2 == this.pos) {
                throw new IllegalArgumentException("integer expected at position " + this.pos);
            }
            int n3 = Integer.parseInt(this.b.substring(n2, this.pos));
            int n4 = -1;
            if (this.match(',')) {
                n2 = this.pos;
                while (this.peek("0123456789")) {
                    this.next();
                }
                if (n2 != this.pos) {
                    n4 = Integer.parseInt(this.b.substring(n2, this.pos));
                }
            } else {
                n4 = n3;
            }
            if (!this.match('}')) {
                throw new IllegalArgumentException("expected '}' at position " + this.pos);
            }
            if (n4 == -1) {
                regExp = RegExp.makeRepeat(regExp, n3);
                continue;
            }
            regExp = RegExp.makeRepeat(regExp, n3, n4);
        }
        return regExp;
    }

    final RegExp parseComplExp() throws IllegalArgumentException {
        if (this.check(2) && this.match('~')) {
            return RegExp.makeComplement(this.parseComplExp());
        }
        return this.parseCharClassExp();
    }

    final RegExp parseCharClassExp() throws IllegalArgumentException {
        if (this.match('[')) {
            boolean bl2 = false;
            if (this.match('^')) {
                bl2 = true;
            }
            RegExp regExp = this.parseCharClasses();
            if (bl2) {
                regExp = RegExp.makeIntersection(RegExp.makeAnyChar(), RegExp.makeComplement(regExp));
            }
            if (!this.match(']')) {
                throw new IllegalArgumentException("expected ']' at position " + this.pos);
            }
            return regExp;
        }
        return this.parseSimpleExp();
    }

    final RegExp parseCharClasses() throws IllegalArgumentException {
        RegExp regExp = this.parseCharClass();
        while (this.more() && !this.peek("]")) {
            regExp = RegExp.makeUnion(regExp, this.parseCharClass());
        }
        return regExp;
    }

    final RegExp parseCharClass() throws IllegalArgumentException {
        char c2 = this.parseCharExp();
        if (this.match('-')) {
            if (this.peek("]")) {
                return RegExp.makeUnion(RegExp.makeChar(c2), RegExp.makeChar('-'));
            }
            return RegExp.makeCharRange(c2, this.parseCharExp());
        }
        return RegExp.makeChar(c2);
    }

    final RegExp parseSimpleExp() throws IllegalArgumentException {
        if (this.match('.')) {
            return RegExp.makeAnyChar();
        }
        if (this.check(4) && this.match('#')) {
            return RegExp.makeEmpty();
        }
        if (this.check(8) && this.match('@')) {
            return RegExp.makeAnyString();
        }
        if (this.check(64) && this.match('\"')) {
            int n2 = this.pos;
            while (this.more() && !this.peek("\"")) {
                this.next();
            }
            if (!this.match('\"')) {
                throw new IllegalArgumentException("expected '\"' at position " + this.pos);
            }
            return RegExp.makeString(this.b.substring(n2, this.pos - 1));
        }
        if (this.match('(')) {
            if (this.match(')')) {
                return RegExp.makeString("");
            }
            RegExp regExp = this.parseUnionExp();
            if (!this.match(')')) {
                throw new IllegalArgumentException("expected ')' at position " + this.pos);
            }
            return regExp;
        }
        if ((this.check(16) || this.check(32)) && this.match('<')) {
            int n3 = this.pos;
            while (this.more() && !this.peek(">")) {
                this.next();
            }
            if (!this.match('>')) {
                throw new IllegalArgumentException("expected '>' at position " + this.pos);
            }
            String string = this.b.substring(n3, this.pos - 1);
            int n4 = string.indexOf(45);
            if (n4 == -1) {
                if (!this.check(16)) {
                    throw new IllegalArgumentException("interval syntax error at position " + (this.pos - 1));
                }
                return RegExp.makeAutomaton(string);
            }
            if (!this.check(32)) {
                throw new IllegalArgumentException("illegal identifier at position " + (this.pos - 1));
            }
            try {
                if (n4 == 0 || n4 == string.length() - 1 || n4 != string.lastIndexOf(45)) {
                    throw new NumberFormatException();
                }
                String string2 = string.substring(0, n4);
                String string3 = string.substring(n4 + 1, string.length());
                int n5 = Integer.parseInt(string2);
                int n6 = Integer.parseInt(string3);
                int n7 = string2.length() == string3.length() ? string2.length() : 0;
                if (n5 > n6) {
                    int n8 = n5;
                    n5 = n6;
                    n6 = n8;
                }
                return RegExp.makeInterval(n5, n6, n7);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("interval syntax error at position " + (this.pos - 1));
            }
        }
        return RegExp.makeChar(this.parseCharExp());
    }

    final char parseCharExp() throws IllegalArgumentException {
        this.match('\\');
        return this.next();
    }

    static enum Kind {
        REGEXP_UNION,
        REGEXP_CONCATENATION,
        REGEXP_INTERSECTION,
        REGEXP_OPTIONAL,
        REGEXP_REPEAT,
        REGEXP_REPEAT_MIN,
        REGEXP_REPEAT_MINMAX,
        REGEXP_COMPLEMENT,
        REGEXP_CHAR,
        REGEXP_CHAR_RANGE,
        REGEXP_ANYCHAR,
        REGEXP_EMPTY,
        REGEXP_STRING,
        REGEXP_ANYSTRING,
        REGEXP_AUTOMATON,
        REGEXP_INTERVAL;

    }
}

