/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.http;

import com.contrastsecurity.thirdparty.io.micrometer.common.util.StringUtils;
import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.http.Outcome;
import jakarta.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Incubating(since="1.4.0")
public class HttpRequestTags {
    private static final Tag EXCEPTION_NONE = Tag.of("exception", "None");
    private static final Tag STATUS_UNKNOWN = Tag.of("status", "UNKNOWN");
    private static final Tag METHOD_UNKNOWN = Tag.of("method", "UNKNOWN");

    private HttpRequestTags() {
    }

    public static Tag method(javax.servlet.http.HttpServletRequest httpServletRequest) {
        return httpServletRequest != null ? Tag.of("method", httpServletRequest.getMethod()) : METHOD_UNKNOWN;
    }

    public static Tag method(HttpServletRequest httpServletRequest) {
        return httpServletRequest != null ? Tag.of("method", httpServletRequest.getMethod()) : METHOD_UNKNOWN;
    }

    public static Tag status(HttpServletResponse httpServletResponse) {
        return httpServletResponse != null ? Tag.of("status", Integer.toString(httpServletResponse.getStatus())) : STATUS_UNKNOWN;
    }

    public static Tag status(jakarta.servlet.http.HttpServletResponse httpServletResponse) {
        return httpServletResponse != null ? Tag.of("status", Integer.toString(httpServletResponse.getStatus())) : STATUS_UNKNOWN;
    }

    public static Tag exception(Throwable throwable) {
        if (throwable != null) {
            String string = throwable.getClass().getSimpleName();
            return Tag.of("exception", StringUtils.isNotBlank(string) ? string : throwable.getClass().getName());
        }
        return EXCEPTION_NONE;
    }

    public static Tag outcome(HttpServletResponse httpServletResponse) {
        Outcome outcome = httpServletResponse != null ? Outcome.forStatus(httpServletResponse.getStatus()) : Outcome.UNKNOWN;
        return outcome.asTag();
    }

    public static Tag outcome(jakarta.servlet.http.HttpServletResponse httpServletResponse) {
        Outcome outcome = httpServletResponse != null ? Outcome.forStatus(httpServletResponse.getStatus()) : Outcome.UNKNOWN;
        return outcome.asTag();
    }
}

