/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.httpcomponents;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNull;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.MeterBinder;
import com.contrastsecurity.thirdparty.org.apache.http.conn.routing.HttpRoute;
import com.contrastsecurity.thirdparty.org.apache.http.pool.ConnPoolControl;

public class PoolingHttpClientConnectionManagerMetricsBinder
implements MeterBinder {
    private final ConnPoolControl<HttpRoute> connPoolControl;
    private final Iterable<Tag> tags;

    public PoolingHttpClientConnectionManagerMetricsBinder(ConnPoolControl<HttpRoute> connPoolControl, String string, String ... stringArray) {
        this(connPoolControl, string, Tags.of(stringArray));
    }

    public PoolingHttpClientConnectionManagerMetricsBinder(ConnPoolControl<HttpRoute> connPoolControl, String string, Iterable<Tag> iterable) {
        this.connPoolControl = connPoolControl;
        this.tags = Tags.concat(iterable, "httpclient", string);
    }

    @Override
    public void bindTo(@NonNull MeterRegistry meterRegistry) {
        this.registerTotalMetrics(meterRegistry);
    }

    private void registerTotalMetrics(MeterRegistry meterRegistry) {
        Gauge.builder("httpcomponents.httpclient.pool.total.max", this.connPoolControl, connPoolControl -> connPoolControl.getTotalStats().getMax()).description("The configured maximum number of allowed persistent connections for all routes.").tags(this.tags).register(meterRegistry);
        Gauge.builder("httpcomponents.httpclient.pool.total.connections", this.connPoolControl, connPoolControl -> connPoolControl.getTotalStats().getAvailable()).description("The number of persistent and available connections for all routes.").tags(this.tags).tag("state", "available").register(meterRegistry);
        Gauge.builder("httpcomponents.httpclient.pool.total.connections", this.connPoolControl, connPoolControl -> connPoolControl.getTotalStats().getLeased()).description("The number of persistent and leased connections for all routes.").tags(this.tags).tag("state", "leased").register(meterRegistry);
        Gauge.builder("httpcomponents.httpclient.pool.total.pending", this.connPoolControl, connPoolControl -> connPoolControl.getTotalStats().getPending()).description("The number of connection requests being blocked awaiting a free connection for all routes.").tags(this.tags).register(meterRegistry);
        Gauge.builder("httpcomponents.httpclient.pool.route.max.default", this.connPoolControl, ConnPoolControl::getDefaultMaxPerRoute).description("The configured default maximum number of allowed persistent connections per route.").tags(this.tags).register(meterRegistry);
    }
}

