/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.okhttp3;

import com.contrastsecurity.thirdparty.io.micrometer.common.KeyValue;
import com.contrastsecurity.thirdparty.io.micrometer.common.KeyValues;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.http.Outcome;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.okhttp3.OkHttpContext;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.okhttp3.OkHttpObservationConvention;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.okhttp3.OkHttpObservationDocumentation;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.okhttp3.OkHttpObservationInterceptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import okhttp3.Request;
import okhttp3.Response;

@NonNullApi
@NonNullFields
public class DefaultOkHttpObservationConvention
implements OkHttpObservationConvention {
    static final boolean REQUEST_TAG_CLASS_EXISTS = DefaultOkHttpObservationConvention.getMethod(Class.class) != null;
    private static final String TAG_TARGET_SCHEME = "target.scheme";
    private static final String TAG_TARGET_HOST = "target.host";
    private static final String TAG_TARGET_PORT = "target.port";
    private static final String TAG_VALUE_UNKNOWN = "UNKNOWN";
    private static final KeyValues TAGS_TARGET_UNKNOWN = KeyValues.of("target.scheme", "UNKNOWN", "target.host", "UNKNOWN", "target.port", "UNKNOWN");
    private final String metricName;

    @Nullable
    private static Method getMethod(Class<?> ... classArray) {
        try {
            return Request.class.getMethod("tag", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public DefaultOkHttpObservationConvention(String string) {
        this.metricName = string;
    }

    @Override
    public KeyValues getLowCardinalityKeyValues(OkHttpContext okHttpContext) {
        OkHttpObservationInterceptor.CallState callState = okHttpContext.getState();
        Request request = callState.request;
        boolean bl2 = request != null;
        Function<Request, String> function = okHttpContext.getUrlMapper();
        Iterable<KeyValue> iterable = okHttpContext.getExtraTags();
        Iterable<BiFunction<Request, Response, KeyValue>> iterable2 = okHttpContext.getContextSpecificTags();
        Iterable<KeyValue> iterable3 = okHttpContext.getUnknownRequestTags();
        boolean bl3 = okHttpContext.isIncludeHostTag();
        KeyValues keyValues = KeyValues.of(OkHttpObservationDocumentation.OkHttpLegacyLowCardinalityTags.METHOD.withValue(bl2 ? request.method() : TAG_VALUE_UNKNOWN), OkHttpObservationDocumentation.OkHttpLegacyLowCardinalityTags.URI.withValue(this.getUriTag(function, callState, request)), OkHttpObservationDocumentation.OkHttpLegacyLowCardinalityTags.STATUS.withValue(this.getStatusMessage(callState.response, callState.exception)), OkHttpObservationDocumentation.OkHttpLegacyLowCardinalityTags.OUTCOME.withValue(this.getStatusOutcome(callState.response).name())).and(iterable).and(StreamSupport.stream(iterable2.spliterator(), false).map(biFunction -> (KeyValue)biFunction.apply(request, callState.response)).map(keyValue -> KeyValue.of(keyValue.getKey(), keyValue.getValue())).collect(Collectors.toList())).and(this.getRequestTags(request, iterable3)).and(this.generateTagsForRoute(request));
        if (bl3) {
            keyValues = KeyValues.of(keyValues).and(OkHttpObservationDocumentation.OkHttpLegacyLowCardinalityTags.HOST.withValue(bl2 ? request.url().host() : TAG_VALUE_UNKNOWN));
        }
        return keyValues;
    }

    private String getUriTag(Function<Request, String> function, OkHttpObservationInterceptor.CallState callState, @Nullable Request request) {
        if (request == null) {
            return TAG_VALUE_UNKNOWN;
        }
        return callState.response != null && (callState.response.code() == 404 || callState.response.code() == 301) ? "NOT_FOUND" : function.apply(request);
    }

    private Outcome getStatusOutcome(@Nullable Response response) {
        if (response == null) {
            return Outcome.UNKNOWN;
        }
        return Outcome.forStatus(response.code());
    }

    private String getStatusMessage(@Nullable Response response, @Nullable IOException iOException) {
        if (iOException != null) {
            return "IO_ERROR";
        }
        if (response == null) {
            return "CLIENT_ERROR";
        }
        return Integer.toString(response.code());
    }

    private Iterable<KeyValue> getRequestTags(@Nullable Request request, Iterable<KeyValue> iterable) {
        Object object;
        if (request == null) {
            return iterable;
        }
        if (REQUEST_TAG_CLASS_EXISTS) {
            object = (Tags)request.tag(Tags.class);
            if (object != null) {
                return this.tagsToKeyValues(((Tags)object).stream());
            }
            KeyValues keyValues = (KeyValues)request.tag(KeyValues.class);
            if (keyValues != null) {
                return keyValues;
            }
        }
        if ((object = request.tag()) instanceof Tags) {
            return this.tagsToKeyValues(((Tags)object).stream());
        }
        if (object instanceof KeyValues) {
            return (KeyValues)object;
        }
        return KeyValues.empty();
    }

    private List<KeyValue> tagsToKeyValues(Stream<Tag> stream) {
        return stream.map(tag -> KeyValue.of(tag.getKey(), tag.getValue())).collect(Collectors.toList());
    }

    private KeyValues generateTagsForRoute(@Nullable Request request) {
        if (request == null) {
            return TAGS_TARGET_UNKNOWN;
        }
        return KeyValues.of(TAG_TARGET_SCHEME, request.url().scheme(), TAG_TARGET_HOST, request.url().host(), TAG_TARGET_PORT, Integer.toString(request.url().port()));
    }

    @Override
    public String getName() {
        return this.metricName;
    }

    @Override
    @Nullable
    public String getContextualName(OkHttpContext okHttpContext) {
        Request request = okHttpContext.getOriginalRequest();
        if (request == null) {
            return null;
        }
        return request.method();
    }
}

