/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.InvalidConfigurationException;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.CountAtBucket;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.FixedBoundaryHistogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.Histogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.HistogramSnapshot;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step.StepValue;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.function.Supplier;

public class StepBucketHistogram
extends StepValue<CountAtBucket[]>
implements Histogram {
    private final FixedBoundaryHistogram fixedBoundaryHistogram;
    private final double[] buckets;

    public StepBucketHistogram(Clock clock, long l2, DistributionStatisticConfig distributionStatisticConfig, boolean bl2, boolean bl3) {
        super(clock, l2, StepBucketHistogram.getEmptyCounts(StepBucketHistogram.getBucketsFromDistributionStatisticConfig(distributionStatisticConfig, bl2)));
        this.buckets = StepBucketHistogram.getBucketsFromDistributionStatisticConfig(distributionStatisticConfig, bl2);
        this.fixedBoundaryHistogram = new FixedBoundaryHistogram(this.buckets, bl3);
    }

    @Override
    public void recordLong(long l2) {
        this.fixedBoundaryHistogram.record(l2);
    }

    @Override
    public void recordDouble(double d2) {
        this.recordLong((long)Math.ceil(d2));
    }

    @Override
    public HistogramSnapshot takeSnapshot(long l2, double d2, double d3) {
        return new HistogramSnapshot(l2, d2, d3, null, (CountAtBucket[])this.poll(), null);
    }

    @Override
    protected Supplier<CountAtBucket[]> valueSupplier() {
        return () -> {
            CountAtBucket[] countAtBucketArray = new CountAtBucket[this.buckets.length];
            FixedBoundaryHistogram fixedBoundaryHistogram = this.fixedBoundaryHistogram;
            synchronized (fixedBoundaryHistogram) {
                Iterator<CountAtBucket> iterator = this.fixedBoundaryHistogram.countsAtValues(Arrays.stream(this.buckets).iterator());
                for (int i2 = 0; i2 < countAtBucketArray.length; ++i2) {
                    countAtBucketArray[i2] = iterator.next();
                }
                this.fixedBoundaryHistogram.reset();
            }
            return countAtBucketArray;
        };
    }

    @Override
    protected CountAtBucket[] noValue() {
        return StepBucketHistogram.getEmptyCounts(this.buckets);
    }

    private static CountAtBucket[] getEmptyCounts(double[] dArray) {
        CountAtBucket[] countAtBucketArray = new CountAtBucket[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            countAtBucketArray[i2] = new CountAtBucket(dArray[i2], 0.0);
        }
        return countAtBucketArray;
    }

    private static double[] getBucketsFromDistributionStatisticConfig(DistributionStatisticConfig distributionStatisticConfig, boolean bl2) {
        if (distributionStatisticConfig.getMaximumExpectedValueAsDouble() == null || distributionStatisticConfig.getMinimumExpectedValueAsDouble() == null) {
            throw new InvalidConfigurationException("minimumExpectedValue and maximumExpectedValue should be greater than 0.");
        }
        NavigableSet<Double> navigableSet = distributionStatisticConfig.getHistogramBuckets(bl2);
        return navigableSet.stream().filter(Objects::nonNull).mapToDouble(Double::doubleValue).toArray();
    }
}

