/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.api;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.logging.log4j2.f;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.OpenTelemetry;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.ConfigUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.logs.LoggerProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.Meter;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.MeterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.MeterProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.Tracer;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.TracerBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.TracerProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.propagation.ContextPropagators;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

public final class GlobalOpenTelemetry {
    private static final String GLOBAL_AUTOCONFIGURE_ENABLED_PROPERTY = "otel.java.global-autoconfigure.enabled";
    private static final f logger = f.a(GlobalOpenTelemetry.class.getName());
    private static final Object mutex = new Object();
    @Nullable
    private static volatile ObfuscatedOpenTelemetry globalOpenTelemetry;
    @Nullable
    private static Throwable setGlobalCaller;

    private GlobalOpenTelemetry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenTelemetry get() {
        ObfuscatedOpenTelemetry obfuscatedOpenTelemetry = globalOpenTelemetry;
        if (obfuscatedOpenTelemetry == null) {
            Object object = mutex;
            synchronized (object) {
                obfuscatedOpenTelemetry = globalOpenTelemetry;
                if (obfuscatedOpenTelemetry == null) {
                    OpenTelemetry openTelemetry = GlobalOpenTelemetry.maybeAutoConfigureAndSetGlobal();
                    if (openTelemetry != null) {
                        return openTelemetry;
                    }
                    GlobalOpenTelemetry.set(OpenTelemetry.noop());
                    return OpenTelemetry.noop();
                }
            }
        }
        return obfuscatedOpenTelemetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(OpenTelemetry openTelemetry) {
        Object object = mutex;
        synchronized (object) {
            if (globalOpenTelemetry != null) {
                throw new IllegalStateException("GlobalOpenTelemetry.set has already been called. GlobalOpenTelemetry.set must be called only once before any calls to GlobalOpenTelemetry.get. If you are using the OpenTelemetrySdk, use OpenTelemetrySdkBuilder.buildAndRegisterGlobal instead. Previous invocation set to cause of this exception.", setGlobalCaller);
            }
            globalOpenTelemetry = new ObfuscatedOpenTelemetry(openTelemetry);
            setGlobalCaller = new Throwable();
        }
    }

    public static TracerProvider getTracerProvider() {
        return GlobalOpenTelemetry.get().getTracerProvider();
    }

    public static Tracer getTracer(String string) {
        return GlobalOpenTelemetry.get().getTracer(string);
    }

    public static Tracer getTracer(String string, String string2) {
        return GlobalOpenTelemetry.get().getTracer(string, string2);
    }

    public static TracerBuilder tracerBuilder(String string) {
        return GlobalOpenTelemetry.get().tracerBuilder(string);
    }

    public static MeterProvider getMeterProvider() {
        return GlobalOpenTelemetry.get().getMeterProvider();
    }

    public static Meter getMeter(String string) {
        return GlobalOpenTelemetry.get().getMeter(string);
    }

    public static MeterBuilder meterBuilder(String string) {
        return GlobalOpenTelemetry.get().meterBuilder(string);
    }

    public static void resetForTest() {
        globalOpenTelemetry = null;
    }

    public static ContextPropagators getPropagators() {
        return GlobalOpenTelemetry.get().getPropagators();
    }

    @Nullable
    private static OpenTelemetry maybeAutoConfigureAndSetGlobal() {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.contrastsecurity.thirdparty.io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        boolean bl2 = Boolean.parseBoolean(ConfigUtil.getString(GLOBAL_AUTOCONFIGURE_ENABLED_PROPERTY, "false"));
        if (!bl2) {
            logger.a(f.a.d, "AutoConfiguredOpenTelemetrySdk found on classpath but automatic configuration is disabled. To enable, run your JVM with -Dotel.java.global-autoconfigure.enabled=true");
            return null;
        }
        try {
            Method method = clazz.getMethod("initialize", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = clazz.getMethod("getOpenTelemetrySdk", new Class[0]);
            return new ObfuscatedOpenTelemetry((OpenTelemetry)method2.invoke(object, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new IllegalStateException("AutoConfiguredOpenTelemetrySdk detected on classpath but could not invoke initialize method. This is a bug in OpenTelemetry.", reflectiveOperationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwables.throwIfCritical(invocationTargetException);
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            logger.a(f.a.b, "Error automatically configuring OpenTelemetry SDK. OpenTelemetry will not be enabled.", invocationTargetException2.getTargetException());
            return null;
        }
    }

    @ThreadSafe
    static class ObfuscatedOpenTelemetry
    implements OpenTelemetry {
        private final OpenTelemetry delegate;

        ObfuscatedOpenTelemetry(OpenTelemetry openTelemetry) {
            this.delegate = openTelemetry;
        }

        @Override
        public TracerProvider getTracerProvider() {
            return this.delegate.getTracerProvider();
        }

        @Override
        public MeterProvider getMeterProvider() {
            return this.delegate.getMeterProvider();
        }

        @Override
        public LoggerProvider getLogsBridge() {
            return this.delegate.getLogsBridge();
        }

        @Override
        public ContextPropagators getPropagators() {
            return this.delegate.getPropagators();
        }

        @Override
        public TracerBuilder tracerBuilder(String string) {
            return this.delegate.tracerBuilder(string);
        }
    }
}

