/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.api.trace;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.OtelEncodingUtils;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.TraceFlags;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ImmutableTraceFlags
implements TraceFlags {
    private static final ImmutableTraceFlags[] INSTANCES = ImmutableTraceFlags.buildInstances();
    private static final byte SAMPLED_BIT = 1;
    static final ImmutableTraceFlags DEFAULT = ImmutableTraceFlags.fromByte((byte)0);
    static final ImmutableTraceFlags SAMPLED = ImmutableTraceFlags.fromByte((byte)1);
    static final int HEX_LENGTH = 2;
    private final String hexRep;
    private final byte byteRep;

    static ImmutableTraceFlags fromHex(CharSequence charSequence, int n2) {
        Objects.requireNonNull(charSequence, "src");
        return ImmutableTraceFlags.fromByte(OtelEncodingUtils.byteFromBase16(charSequence.charAt(n2), charSequence.charAt(n2 + 1)));
    }

    static ImmutableTraceFlags fromByte(byte by2) {
        return INSTANCES[by2 & 0xFF];
    }

    private static ImmutableTraceFlags[] buildInstances() {
        ImmutableTraceFlags[] immutableTraceFlagsArray = new ImmutableTraceFlags[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            immutableTraceFlagsArray[i2] = new ImmutableTraceFlags((byte)i2);
        }
        return immutableTraceFlagsArray;
    }

    private ImmutableTraceFlags(byte by2) {
        char[] cArray = new char[2];
        OtelEncodingUtils.byteToBase16(by2, cArray, 0);
        this.hexRep = new String(cArray);
        this.byteRep = by2;
    }

    @Override
    public boolean isSampled() {
        return (this.byteRep & 1) != 0;
    }

    @Override
    public String asHex() {
        return this.hexRep;
    }

    @Override
    public byte asByte() {
        return this.byteRep;
    }

    public String toString() {
        return this.asHex();
    }
}

