/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.api.trace;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.ApiUsageLogger;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.PropagatedSpan;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.SpanContext;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.SpanContextKey;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.StatusCode;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.ImplicitContextKeyed;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface Span
extends ImplicitContextKeyed {
    public static Span current() {
        Span span = Context.current().get(SpanContextKey.KEY);
        return span == null ? Span.getInvalid() : span;
    }

    public static Span fromContext(Context context) {
        if (context == null) {
            ApiUsageLogger.log("context is null");
            return Span.getInvalid();
        }
        Span span = context.get(SpanContextKey.KEY);
        return span == null ? Span.getInvalid() : span;
    }

    @Nullable
    public static Span fromContextOrNull(Context context) {
        if (context == null) {
            ApiUsageLogger.log("context is null");
            return null;
        }
        return context.get(SpanContextKey.KEY);
    }

    public static Span getInvalid() {
        return PropagatedSpan.INVALID;
    }

    public static Span wrap(SpanContext spanContext) {
        if (spanContext == null) {
            ApiUsageLogger.log("context is null");
            return Span.getInvalid();
        }
        if (!spanContext.isValid()) {
            return Span.getInvalid();
        }
        return PropagatedSpan.create(spanContext);
    }

    default public Span setAttribute(String string, String string2) {
        return this.setAttribute(AttributeKey.stringKey(string), string2);
    }

    default public Span setAttribute(String string, long l2) {
        return this.setAttribute(AttributeKey.longKey(string), Long.valueOf(l2));
    }

    default public Span setAttribute(String string, double d2) {
        return this.setAttribute(AttributeKey.doubleKey(string), Double.valueOf(d2));
    }

    default public Span setAttribute(String string, boolean bl2) {
        return this.setAttribute(AttributeKey.booleanKey(string), Boolean.valueOf(bl2));
    }

    public <T> Span setAttribute(AttributeKey<T> var1, T var2);

    default public Span setAttribute(AttributeKey<Long> attributeKey, int n2) {
        return this.setAttribute(attributeKey, Long.valueOf(n2));
    }

    default public Span setAllAttributes(Attributes attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return this;
        }
        attributes.forEach((attributeKey, object) -> this.setAttribute((AttributeKey)attributeKey, (Object)object));
        return this;
    }

    default public Span addEvent(String string) {
        return this.addEvent(string, Attributes.empty());
    }

    default public Span addEvent(String string, long l2, TimeUnit timeUnit) {
        return this.addEvent(string, Attributes.empty(), l2, timeUnit);
    }

    default public Span addEvent(String string, Instant instant) {
        if (instant == null) {
            return this.addEvent(string);
        }
        return this.addEvent(string, TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano(), TimeUnit.NANOSECONDS);
    }

    public Span addEvent(String var1, Attributes var2);

    public Span addEvent(String var1, Attributes var2, long var3, TimeUnit var5);

    default public Span addEvent(String string, Attributes attributes, Instant instant) {
        if (instant == null) {
            return this.addEvent(string, attributes);
        }
        return this.addEvent(string, attributes, TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano(), TimeUnit.NANOSECONDS);
    }

    default public Span setStatus(StatusCode statusCode) {
        return this.setStatus(statusCode, "");
    }

    public Span setStatus(StatusCode var1, String var2);

    default public Span recordException(Throwable throwable) {
        return this.recordException(throwable, Attributes.empty());
    }

    public Span recordException(Throwable var1, Attributes var2);

    public Span updateName(String var1);

    public void end();

    public void end(long var1, TimeUnit var3);

    default public void end(Instant instant) {
        if (instant == null) {
            this.end();
            return;
        }
        this.end(TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano(), TimeUnit.NANOSECONDS);
    }

    public SpanContext getSpanContext();

    public boolean isRecording();

    @Override
    default public Context storeInContext(Context context) {
        return context.with(SpanContextKey.KEY, this);
    }
}

