/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.propagation.internal;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.Utils;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.TraceState;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.TraceStateBuilder;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class W3CTraceContextEncoding {
    private static final int TRACESTATE_MAX_SIZE = 512;
    private static final int TRACESTATE_MAX_MEMBERS = 32;
    private static final char TRACESTATE_KEY_VALUE_DELIMITER = '=';
    private static final char TRACESTATE_ENTRY_DELIMITER = ',';
    private static final Pattern TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN = Pattern.compile("[ \t]*,[ \t]*");

    private W3CTraceContextEncoding() {
    }

    public static TraceState decodeTraceState(String string) {
        TraceStateBuilder traceStateBuilder = TraceState.builder();
        String[] stringArray = TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN.split(string);
        Utils.checkArgument(stringArray.length <= 32, "TraceState has too many elements.");
        for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
            String string2 = stringArray[i2];
            int n2 = string2.indexOf(61);
            Utils.checkArgument(n2 != -1, "Invalid TraceState list-member format.");
            traceStateBuilder.put(string2.substring(0, n2), string2.substring(n2 + 1));
        }
        TraceState traceState = traceStateBuilder.build();
        if (traceState.size() != stringArray.length) {
            return TraceState.getDefault();
        }
        return traceState;
    }

    public static String encodeTraceState(TraceState traceState) {
        if (traceState.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(512);
        traceState.forEach((string, string2) -> {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append((String)string).append('=').append((String)string2);
        });
        return stringBuilder.toString();
    }
}

