/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.context;

import com.contrastsecurity.agent.logging.log4j2.f;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.ContextStorage;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Scope;
import javax.annotation.Nullable;

enum ThreadLocalContextStorage implements ContextStorage
{
    INSTANCE;

    private static final f logger;
    private static final ThreadLocal<Context> THREAD_LOCAL_STORAGE;

    @Override
    public Scope attach(Context context) {
        if (context == null) {
            return NoopScope.INSTANCE;
        }
        Context context2 = this.current();
        if (context == context2) {
            return NoopScope.INSTANCE;
        }
        THREAD_LOCAL_STORAGE.set(context);
        return new ScopeImpl(context2, context);
    }

    @Override
    @Nullable
    public Context current() {
        return THREAD_LOCAL_STORAGE.get();
    }

    static {
        logger = f.a(ThreadLocalContextStorage.class.getName());
        THREAD_LOCAL_STORAGE = new ThreadLocal();
    }

    static enum NoopScope implements Scope
    {
        INSTANCE;


        @Override
        public void close() {
        }
    }

    private class ScopeImpl
    implements Scope {
        @Nullable
        private final Context beforeAttach;
        private final Context toAttach;
        private boolean closed;

        private ScopeImpl(Context context, Context context2) {
            this.beforeAttach = context;
            this.toAttach = context2;
        }

        @Override
        public void close() {
            if (!this.closed && ThreadLocalContextStorage.this.current() == this.toAttach) {
                this.closed = true;
                THREAD_LOCAL_STORAGE.set(this.beforeAttach);
            } else {
                logger.a(f.a.f, " Trying to close scope which does not represent current context. Ignoring the call.");
            }
        }
    }
}

