/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal;

import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.TlsUtil;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class TlsConfigHelper {
    @Nullable
    private X509KeyManager keyManager;
    @Nullable
    private X509TrustManager trustManager;
    @Nullable
    private SSLContext sslContext;

    public void setTrustManagerFromCerts(byte[] byArray) {
        if (this.trustManager != null) {
            throw new IllegalStateException("trustManager has been previously configured");
        }
        try {
            this.trustManager = TlsUtil.trustManager(byArray);
        }
        catch (SSLException sSLException) {
            throw new IllegalStateException("Error creating X509TrustManager with provided certs. Are they valid X.509 in PEM format?", sSLException);
        }
    }

    public void setKeyManagerFromCerts(byte[] byArray, byte[] byArray2) {
        if (this.keyManager != null) {
            throw new IllegalStateException("keyManager has been previously configured");
        }
        try {
            this.keyManager = TlsUtil.keyManager(byArray, byArray2);
        }
        catch (SSLException sSLException) {
            throw new IllegalStateException("Error creating X509KeyManager with provided certs. Are they valid X.509 in PEM format?", sSLException);
        }
    }

    public void setSslContext(SSLContext sSLContext, X509TrustManager x509TrustManager) {
        if (this.sslContext != null || this.trustManager != null) {
            throw new IllegalStateException("sslContext or trustManager has been previously configured");
        }
        this.trustManager = x509TrustManager;
        this.sslContext = sSLContext;
    }

    @Nullable
    public X509KeyManager getKeyManager() {
        return this.keyManager;
    }

    @Nullable
    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }

    @Nullable
    public SSLContext getSslContext() {
        if (this.sslContext != null) {
            return this.sslContext;
        }
        try {
            TrustManager[] trustManagerArray;
            KeyManager[] keyManagerArray;
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            if (this.keyManager == null) {
                keyManagerArray = null;
            } else {
                KeyManager[] keyManagerArray2 = new KeyManager[1];
                keyManagerArray = keyManagerArray2;
                keyManagerArray2[0] = this.keyManager;
            }
            if (this.trustManager == null) {
                trustManagerArray = null;
            } else {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = this.trustManager;
            }
            sSLContext.init(keyManagerArray, trustManagerArray, null);
            return sSLContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            throw new IllegalArgumentException(generalSecurityException);
        }
    }

    public TlsConfigHelper copy() {
        TlsConfigHelper tlsConfigHelper = new TlsConfigHelper();
        tlsConfigHelper.keyManager = this.keyManager;
        tlsConfigHelper.trustManager = this.trustManager;
        tlsConfigHelper.sslContext = this.sslContext;
        return tlsConfigHelper;
    }
}

