/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.http;

import com.contrastsecurity.agent.logging.log4j2.f;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.GlobalOpenTelemetry;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.ConfigUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.MeterProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.ExporterBuilderUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.TlsConfigHelper;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.auth.Authenticator;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.http.HttpExporter;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.http.HttpSender;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.http.HttpSenderProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.export.RetryPolicy;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class HttpExporterBuilder<T extends Marshaler> {
    public static final long DEFAULT_TIMEOUT_SECS = 10L;
    private static final f LOGGER = f.a(HttpExporterBuilder.class.getName());
    private final String exporterName;
    private final String type;
    private String endpoint;
    private long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
    private boolean compressionEnabled = false;
    private boolean exportAsJson = false;
    @Nullable
    private Map<String, String> headers;
    private TlsConfigHelper tlsConfigHelper = new TlsConfigHelper();
    @Nullable
    private RetryPolicy retryPolicy;
    private Supplier<MeterProvider> meterProviderSupplier = GlobalOpenTelemetry::getMeterProvider;
    @Nullable
    private Authenticator authenticator;

    public HttpExporterBuilder(String string, String string2, String string3) {
        this.exporterName = string;
        this.type = string2;
        this.endpoint = string3;
    }

    public HttpExporterBuilder<T> setTimeout(long l2, TimeUnit timeUnit) {
        this.timeoutNanos = timeUnit.toNanos(l2);
        return this;
    }

    public HttpExporterBuilder<T> setTimeout(Duration duration) {
        return this.setTimeout(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public HttpExporterBuilder<T> setEndpoint(String string) {
        URI uRI = ExporterBuilderUtil.validateEndpoint(string);
        this.endpoint = uRI.toString();
        return this;
    }

    public HttpExporterBuilder<T> setCompression(String string) {
        this.compressionEnabled = string.equals("gzip");
        return this;
    }

    public HttpExporterBuilder<T> addHeader(String string, String string2) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(string, string2);
        return this;
    }

    public HttpExporterBuilder<T> setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public HttpExporterBuilder<T> setTrustManagerFromCerts(byte[] byArray) {
        this.tlsConfigHelper.setTrustManagerFromCerts(byArray);
        return this;
    }

    public HttpExporterBuilder<T> setKeyManagerFromCerts(byte[] byArray, byte[] byArray2) {
        this.tlsConfigHelper.setKeyManagerFromCerts(byArray, byArray2);
        return this;
    }

    public HttpExporterBuilder<T> setSslContext(SSLContext sSLContext, X509TrustManager x509TrustManager) {
        this.tlsConfigHelper.setSslContext(sSLContext, x509TrustManager);
        return this;
    }

    public HttpExporterBuilder<T> setMeterProvider(MeterProvider meterProvider) {
        this.meterProviderSupplier = () -> meterProvider;
        return this;
    }

    public HttpExporterBuilder<T> setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public HttpExporterBuilder<T> exportAsJson() {
        this.exportAsJson = true;
        return this;
    }

    public HttpExporterBuilder<T> copy() {
        HttpExporterBuilder<T> httpExporterBuilder = new HttpExporterBuilder<T>(this.exporterName, this.type, this.endpoint);
        httpExporterBuilder.endpoint = this.endpoint;
        httpExporterBuilder.timeoutNanos = this.timeoutNanos;
        httpExporterBuilder.exportAsJson = this.exportAsJson;
        httpExporterBuilder.compressionEnabled = this.compressionEnabled;
        if (this.headers != null) {
            httpExporterBuilder.headers = new HashMap<String, String>(this.headers);
        }
        httpExporterBuilder.tlsConfigHelper = this.tlsConfigHelper.copy();
        if (this.retryPolicy != null) {
            httpExporterBuilder.retryPolicy = this.retryPolicy.toBuilder().build();
        }
        httpExporterBuilder.meterProviderSupplier = this.meterProviderSupplier;
        httpExporterBuilder.authenticator = this.authenticator;
        return httpExporterBuilder;
    }

    public HttpExporter<T> build() {
        Map<Object, Object> map = this.headers == null ? Collections.emptyMap() : this.headers;
        Supplier<Map<String, String>> supplier = () -> map;
        HttpSenderProvider httpSenderProvider = HttpExporterBuilder.resolveHttpSenderProvider();
        HttpSender httpSender = httpSenderProvider.createSender(this.endpoint, this.compressionEnabled, this.exportAsJson ? "application/json" : "application/x-protobuf", this.timeoutNanos, supplier, this.authenticator, this.retryPolicy, this.tlsConfigHelper.getSslContext(), this.tlsConfigHelper.getTrustManager());
        LOGGER.a(f.a.f, "Using HttpSender: " + httpSender.getClass().getName());
        return new HttpExporter(this.exporterName, this.type, httpSender, this.meterProviderSupplier, this.exportAsJson);
    }

    public String toString(boolean bl2) {
        StringJoiner stringJoiner = bl2 ? new StringJoiner(", ", "HttpExporterBuilder{", "}") : new StringJoiner(", ");
        stringJoiner.add("exporterName=" + this.exporterName);
        stringJoiner.add("type=" + this.type);
        stringJoiner.add("endpoint=" + this.endpoint);
        stringJoiner.add("timeoutNanos=" + this.timeoutNanos);
        stringJoiner.add("compressionEnabled=" + this.compressionEnabled);
        stringJoiner.add("exportAsJson=" + this.exportAsJson);
        if (this.headers != null) {
            StringJoiner stringJoiner2 = new StringJoiner(", ", "Headers{", "}");
            this.headers.forEach((string, string2) -> stringJoiner2.add(string + "=OBFUSCATED"));
            stringJoiner.add("headers=" + stringJoiner2);
        }
        if (this.retryPolicy != null) {
            stringJoiner.add("retryPolicy=" + this.retryPolicy);
        }
        return stringJoiner.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    private static HttpSenderProvider resolveHttpSenderProvider() {
        HashMap<String, HttpSenderProvider> hashMap = new HashMap<String, HttpSenderProvider>();
        for (HttpSenderProvider httpSenderProvider : ServiceLoader.load(HttpSenderProvider.class, HttpExporterBuilder.class.getClassLoader())) {
            hashMap.put(httpSenderProvider.getClass().getName(), httpSenderProvider);
        }
        if (hashMap.isEmpty()) {
            throw new IllegalStateException("No HttpSenderProvider found on classpath. Please add dependency on opentelemetry-exporter-sender-okhttp or opentelemetry-exporter-sender-jdk");
        }
        if (hashMap.size() == 1) {
            return (HttpSenderProvider)hashMap.values().stream().findFirst().get();
        }
        String string = ConfigUtil.getString("com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.http.HttpSenderProvider", "");
        if (string.isEmpty()) {
            LOGGER.a(f.a.c, "Multiple HttpSenderProvider found. Please include only one, or specify preference setting io.opentelemetry.exporter.internal.http.HttpSenderProvider to the FQCN of the preferred provider.");
            return (HttpSenderProvider)hashMap.values().stream().findFirst().get();
        }
        if (hashMap.containsKey(string)) {
            return (HttpSenderProvider)hashMap.get(string);
        }
        throw new IllegalStateException("No HttpSenderProvider matched configured io.opentelemetry.exporter.internal.http.HttpSenderProvider: " + (String)string);
    }
}

