/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.ConfigUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.WireFormat;
import java.io.IOException;
import java.io.OutputStream;

public abstract class CodedOutputStream {
    private static final int DEFAULT_BUFFER_SIZE;
    private static final ThreadLocal<OutputStreamEncoder> THREAD_LOCAL_CODED_OUTPUT_STREAM;

    static CodedOutputStream newInstance(OutputStream outputStream) {
        OutputStreamEncoder outputStreamEncoder = THREAD_LOCAL_CODED_OUTPUT_STREAM.get();
        if (outputStreamEncoder == null) {
            outputStreamEncoder = new OutputStreamEncoder(outputStream);
            THREAD_LOCAL_CODED_OUTPUT_STREAM.set(outputStreamEncoder);
        } else {
            outputStreamEncoder.reset(outputStream);
        }
        return outputStreamEncoder;
    }

    private CodedOutputStream() {
    }

    final void writeRawBytes(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    abstract void writeInt32NoTag(int var1) throws IOException;

    abstract void writeUInt32NoTag(int var1) throws IOException;

    final void writeSInt32NoTag(int n2) throws IOException {
        this.writeUInt32NoTag(CodedOutputStream.encodeZigZag32(n2));
    }

    abstract void writeFixed32NoTag(int var1) throws IOException;

    final void writeSFixed32NoTag(int n2) throws IOException {
        this.writeFixed32NoTag(n2);
    }

    final void writeInt64NoTag(long l2) throws IOException {
        this.writeUInt64NoTag(l2);
    }

    abstract void writeUInt64NoTag(long var1) throws IOException;

    final void writeSInt64NoTag(long l2) throws IOException {
        this.writeUInt64NoTag(CodedOutputStream.encodeZigZag64(l2));
    }

    abstract void writeFixed64NoTag(long var1) throws IOException;

    final void writeSFixed64NoTag(long l2) throws IOException {
        this.writeFixed64NoTag(l2);
    }

    final void writeFloatNoTag(float f2) throws IOException {
        this.writeFixed32NoTag(Float.floatToRawIntBits(f2));
    }

    final void writeDoubleNoTag(double d2) throws IOException {
        this.writeFixed64NoTag(Double.doubleToRawLongBits(d2));
    }

    final void writeBoolNoTag(boolean bl2) throws IOException {
        this.write((byte)(bl2 ? 1 : 0));
    }

    final void writeEnumNoTag(int n2) throws IOException {
        this.writeInt32NoTag(n2);
    }

    final void writeByteArrayNoTag(byte[] byArray) throws IOException {
        this.writeByteArrayNoTag(byArray, 0, byArray.length);
    }

    abstract void write(byte var1) throws IOException;

    abstract void write(byte[] var1, int var2, int var3) throws IOException;

    static int computeTagSize(int n2) {
        return CodedOutputStream.computeUInt32SizeNoTag(WireFormat.makeTag(n2, 0));
    }

    static int computeInt32SizeNoTag(int n2) {
        if (n2 >= 0) {
            return CodedOutputStream.computeUInt32SizeNoTag(n2);
        }
        return 10;
    }

    static int computeUInt32SizeNoTag(int n2) {
        if ((n2 & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n2 & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n2 & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n2 & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    static int computeSInt32SizeNoTag(int n2) {
        return CodedOutputStream.computeUInt32SizeNoTag(CodedOutputStream.encodeZigZag32(n2));
    }

    static int computeFixed32SizeNoTag(int n2) {
        return 4;
    }

    static int computeSFixed32SizeNoTag(int n2) {
        return 4;
    }

    public static int computeInt64SizeNoTag(long l2) {
        return CodedOutputStream.computeUInt64SizeNoTag(l2);
    }

    static int computeUInt64SizeNoTag(long l2) {
        if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l2 < 0L) {
            return 10;
        }
        int n2 = 2;
        if ((l2 & 0xFFFFFFF800000000L) != 0L) {
            n2 += 4;
            l2 >>>= 28;
        }
        if ((l2 & 0xFFFFFFFFFFE00000L) != 0L) {
            n2 += 2;
            l2 >>>= 14;
        }
        if ((l2 & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n2;
        }
        return n2;
    }

    static int computeSInt64SizeNoTag(long l2) {
        return CodedOutputStream.computeUInt64SizeNoTag(CodedOutputStream.encodeZigZag64(l2));
    }

    static int computeFixed64SizeNoTag(long l2) {
        return 8;
    }

    static int computeSFixed64SizeNoTag(long l2) {
        return 8;
    }

    static int computeFloatSizeNoTag(float f2) {
        return 4;
    }

    public static int computeDoubleSizeNoTag(double d2) {
        return 8;
    }

    public static int computeBoolSizeNoTag(boolean bl2) {
        return 1;
    }

    static int computeEnumSizeNoTag(int n2) {
        return CodedOutputStream.computeInt32SizeNoTag(n2);
    }

    public static int computeByteArraySizeNoTag(byte[] byArray) {
        return CodedOutputStream.computeLengthDelimitedFieldSize(byArray.length);
    }

    static int computeLengthDelimitedFieldSize(int n2) {
        return CodedOutputStream.computeUInt32SizeNoTag(n2) + n2;
    }

    static int encodeZigZag32(int n2) {
        return n2 << 1 ^ n2 >> 31;
    }

    static long encodeZigZag64(long l2) {
        return l2 << 1 ^ l2 >> 63;
    }

    abstract void flush() throws IOException;

    abstract void writeByteArrayNoTag(byte[] var1, int var2, int var3) throws IOException;

    static {
        int n2 = 51200;
        try {
            String string = ConfigUtil.getString("otel.experimental.otlp.buffer-size", "");
            if (!string.isEmpty()) {
                n2 = Integer.parseInt(string);
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
        }
        DEFAULT_BUFFER_SIZE = n2;
        THREAD_LOCAL_CODED_OUTPUT_STREAM = new ThreadLocal();
    }

    private static final class OutputStreamEncoder
    extends AbstractBufferedEncoder {
        private OutputStream out;

        OutputStreamEncoder(OutputStream outputStream) {
            super(DEFAULT_BUFFER_SIZE);
            this.out = outputStream;
        }

        void reset(OutputStream outputStream) {
            this.out = outputStream;
            this.position = 0;
            this.totalBytesWritten = 0;
        }

        @Override
        void writeByteArrayNoTag(byte[] byArray, int n2, int n3) throws IOException {
            this.writeUInt32NoTag(n3);
            this.write(byArray, n2, n3);
        }

        @Override
        void write(byte by2) throws IOException {
            if (this.position == this.limit) {
                this.doFlush();
            }
            this.buffer(by2);
        }

        @Override
        void writeInt32NoTag(int n2) throws IOException {
            if (n2 >= 0) {
                this.writeUInt32NoTag(n2);
            } else {
                this.writeUInt64NoTag(n2);
            }
        }

        @Override
        void writeUInt32NoTag(int n2) throws IOException {
            this.flushIfNotAvailable(5);
            this.bufferUInt32NoTag(n2);
        }

        @Override
        void writeFixed32NoTag(int n2) throws IOException {
            this.flushIfNotAvailable(4);
            this.bufferFixed32NoTag(n2);
        }

        @Override
        void writeUInt64NoTag(long l2) throws IOException {
            this.flushIfNotAvailable(10);
            this.bufferUInt64NoTag(l2);
        }

        @Override
        void writeFixed64NoTag(long l2) throws IOException {
            this.flushIfNotAvailable(8);
            this.bufferFixed64NoTag(l2);
        }

        @Override
        void flush() throws IOException {
            if (this.position > 0) {
                this.doFlush();
            }
        }

        @Override
        void write(byte[] byArray, int n2, int n3) throws IOException {
            if (this.limit - this.position >= n3) {
                System.arraycopy(byArray, n2, this.buffer, this.position, n3);
                this.position += n3;
                this.totalBytesWritten += n3;
            } else {
                int n4 = this.limit - this.position;
                System.arraycopy(byArray, n2, this.buffer, this.position, n4);
                n2 += n4;
                this.position = this.limit;
                this.totalBytesWritten += n4;
                this.doFlush();
                if ((n3 -= n4) <= this.limit) {
                    System.arraycopy(byArray, n2, this.buffer, 0, n3);
                    this.position = n3;
                } else {
                    this.out.write(byArray, n2, n3);
                }
                this.totalBytesWritten += n3;
            }
        }

        private void flushIfNotAvailable(int n2) throws IOException {
            if (this.limit - this.position < n2) {
                this.doFlush();
            }
        }

        private void doFlush() throws IOException {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    private static abstract class AbstractBufferedEncoder
    extends CodedOutputStream {
        final byte[] buffer;
        final int limit;
        int position;
        int totalBytesWritten;

        AbstractBufferedEncoder(int n2) {
            this.buffer = new byte[n2];
            this.limit = this.buffer.length;
        }

        final void buffer(byte by2) {
            this.buffer[this.position++] = by2;
            ++this.totalBytesWritten;
        }

        final void bufferUInt32NoTag(int n2) {
            while (true) {
                if ((n2 & 0xFFFFFF80) == 0) {
                    this.buffer[this.position++] = (byte)n2;
                    ++this.totalBytesWritten;
                    return;
                }
                this.buffer[this.position++] = (byte)(n2 & 0x7F | 0x80);
                ++this.totalBytesWritten;
                n2 >>>= 7;
            }
        }

        final void bufferUInt64NoTag(long l2) {
            while (true) {
                if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    this.buffer[this.position++] = (byte)l2;
                    ++this.totalBytesWritten;
                    return;
                }
                this.buffer[this.position++] = (byte)((int)l2 & 0x7F | 0x80);
                ++this.totalBytesWritten;
                l2 >>>= 7;
            }
        }

        final void bufferFixed32NoTag(int n2) {
            this.buffer[this.position++] = (byte)(n2 & 0xFF);
            this.buffer[this.position++] = (byte)(n2 >> 8 & 0xFF);
            this.buffer[this.position++] = (byte)(n2 >> 16 & 0xFF);
            this.buffer[this.position++] = (byte)(n2 >> 24 & 0xFF);
            this.totalBytesWritten += 4;
        }

        final void bufferFixed64NoTag(long l2) {
            this.buffer[this.position++] = (byte)(l2 & 0xFFL);
            this.buffer[this.position++] = (byte)(l2 >> 8 & 0xFFL);
            this.buffer[this.position++] = (byte)(l2 >> 16 & 0xFFL);
            this.buffer[this.position++] = (byte)(l2 >> 24 & 0xFFL);
            this.buffer[this.position++] = (byte)((int)(l2 >> 32) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(l2 >> 40) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(l2 >> 48) & 0xFF);
            this.buffer[this.position++] = (byte)((int)(l2 >> 56) & 0xFF);
            this.totalBytesWritten += 8;
        }
    }
}

