/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal;

import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

public abstract class Serializer
implements AutoCloseable {
    Serializer() {
    }

    public void serializeTraceId(ProtoFieldInfo protoFieldInfo, @Nullable String string) throws IOException {
        if (string == null) {
            return;
        }
        this.writeTraceId(protoFieldInfo, string);
    }

    protected abstract void writeTraceId(ProtoFieldInfo var1, String var2) throws IOException;

    public void serializeSpanId(ProtoFieldInfo protoFieldInfo, @Nullable String string) throws IOException {
        if (string == null) {
            return;
        }
        this.writeSpanId(protoFieldInfo, string);
    }

    protected abstract void writeSpanId(ProtoFieldInfo var1, String var2) throws IOException;

    public void serializeBool(ProtoFieldInfo protoFieldInfo, boolean bl2) throws IOException {
        if (!bl2) {
            return;
        }
        this.writeBool(protoFieldInfo, bl2);
    }

    public abstract void writeBool(ProtoFieldInfo var1, boolean var2) throws IOException;

    public void serializeEnum(ProtoFieldInfo protoFieldInfo, ProtoEnumInfo protoEnumInfo) throws IOException {
        if (protoEnumInfo.getEnumNumber() == 0) {
            return;
        }
        this.writeEnum(protoFieldInfo, protoEnumInfo);
    }

    protected abstract void writeEnum(ProtoFieldInfo var1, ProtoEnumInfo var2) throws IOException;

    public void serializeUInt32(ProtoFieldInfo protoFieldInfo, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        this.writeUint32(protoFieldInfo, n2);
    }

    protected abstract void writeUint32(ProtoFieldInfo var1, int var2) throws IOException;

    public void serializeSInt32(ProtoFieldInfo protoFieldInfo, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        this.writeSInt32(protoFieldInfo, n2);
    }

    protected abstract void writeSInt32(ProtoFieldInfo var1, int var2) throws IOException;

    public void serializeInt32(ProtoFieldInfo protoFieldInfo, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        this.writeint32(protoFieldInfo, n2);
    }

    protected abstract void writeint32(ProtoFieldInfo var1, int var2) throws IOException;

    public void serializeInt64(ProtoFieldInfo protoFieldInfo, long l2) throws IOException {
        if (l2 == 0L) {
            return;
        }
        this.writeInt64(protoFieldInfo, l2);
    }

    public abstract void writeInt64(ProtoFieldInfo var1, long var2) throws IOException;

    public void serializeFixed64(ProtoFieldInfo protoFieldInfo, long l2) throws IOException {
        if (l2 == 0L) {
            return;
        }
        this.writeFixed64(protoFieldInfo, l2);
    }

    public void serializeFixed64Optional(ProtoFieldInfo protoFieldInfo, long l2) throws IOException {
        this.writeFixed64(protoFieldInfo, l2);
    }

    protected abstract void writeFixed64(ProtoFieldInfo var1, long var2) throws IOException;

    protected abstract void writeFixed64Value(long var1) throws IOException;

    protected abstract void writeUInt64Value(long var1) throws IOException;

    public void serializeFixed32(ProtoFieldInfo protoFieldInfo, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        this.writeFixed32(protoFieldInfo, n2);
    }

    protected abstract void writeFixed32(ProtoFieldInfo var1, int var2) throws IOException;

    public void serializeDouble(ProtoFieldInfo protoFieldInfo, double d2) throws IOException {
        if (d2 == 0.0) {
            return;
        }
        this.writeDouble(protoFieldInfo, d2);
    }

    public void serializeDoubleOptional(ProtoFieldInfo protoFieldInfo, double d2) throws IOException {
        this.writeDouble(protoFieldInfo, d2);
    }

    public abstract void writeDouble(ProtoFieldInfo var1, double var2) throws IOException;

    protected abstract void writeDoubleValue(double var1) throws IOException;

    public void serializeString(ProtoFieldInfo protoFieldInfo, byte[] byArray) throws IOException {
        if (byArray.length == 0) {
            return;
        }
        this.writeString(protoFieldInfo, byArray);
    }

    public abstract void writeString(ProtoFieldInfo var1, byte[] var2) throws IOException;

    public void serializeBytes(ProtoFieldInfo protoFieldInfo, byte[] byArray) throws IOException {
        if (byArray.length == 0) {
            return;
        }
        this.writeBytes(protoFieldInfo, byArray);
    }

    protected abstract void writeBytes(ProtoFieldInfo var1, byte[] var2) throws IOException;

    protected abstract void writeStartMessage(ProtoFieldInfo var1, int var2) throws IOException;

    protected abstract void writeEndMessage() throws IOException;

    public void serializeMessage(ProtoFieldInfo protoFieldInfo, Marshaler marshaler) throws IOException {
        this.writeStartMessage(protoFieldInfo, marshaler.getBinarySerializedSize());
        marshaler.writeTo(this);
        this.writeEndMessage();
    }

    protected abstract void writeStartRepeatedPrimitive(ProtoFieldInfo var1, int var2, int var3) throws IOException;

    protected abstract void writeEndRepeatedPrimitive() throws IOException;

    protected abstract void writeStartRepeatedVarint(ProtoFieldInfo var1, int var2) throws IOException;

    protected abstract void writeEndRepeatedVarint() throws IOException;

    public void serializeRepeatedFixed64(ProtoFieldInfo protoFieldInfo, List<Long> list) throws IOException {
        if (list.isEmpty()) {
            return;
        }
        this.writeStartRepeatedPrimitive(protoFieldInfo, 8, list.size());
        for (long l2 : list) {
            this.writeFixed64Value(l2);
        }
        this.writeEndRepeatedPrimitive();
    }

    public void serializeRepeatedFixed64(ProtoFieldInfo protoFieldInfo, long[] lArray) throws IOException {
        if (lArray.length == 0) {
            return;
        }
        this.writeStartRepeatedPrimitive(protoFieldInfo, 8, lArray.length);
        for (long l2 : lArray) {
            this.writeFixed64Value(l2);
        }
        this.writeEndRepeatedPrimitive();
    }

    public void serializeRepeatedUInt64(ProtoFieldInfo protoFieldInfo, long[] lArray) throws IOException {
        if (lArray.length == 0) {
            return;
        }
        int n2 = 0;
        for (long l2 : lArray) {
            n2 += CodedOutputStream.computeUInt64SizeNoTag(l2);
        }
        this.writeStartRepeatedVarint(protoFieldInfo, n2);
        for (long l2 : lArray) {
            this.writeUInt64Value(l2);
        }
        this.writeEndRepeatedVarint();
    }

    public void serializeRepeatedDouble(ProtoFieldInfo protoFieldInfo, List<Double> list) throws IOException {
        if (list.isEmpty()) {
            return;
        }
        this.writeStartRepeatedPrimitive(protoFieldInfo, 8, list.size());
        for (double d2 : list) {
            this.writeDoubleValue(d2);
        }
        this.writeEndRepeatedPrimitive();
    }

    public abstract void serializeRepeatedMessage(ProtoFieldInfo var1, Marshaler[] var2) throws IOException;

    public abstract void serializeRepeatedMessage(ProtoFieldInfo var1, List<? extends Marshaler> var2) throws IOException;

    public abstract void writeSerializedMessage(byte[] var1, String var2) throws IOException;

    @Override
    public abstract void close() throws IOException;
}

