/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics;

import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics.ValueAtQuantileMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.internal.SummaryDataPoint;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.SummaryPointData;
import java.io.IOException;
import java.util.Collection;

final class SummaryDataPointMarshaler
extends MarshalerWithSize {
    private final long startTimeUnixNano;
    private final long timeUnixNano;
    private final long count;
    private final double sum;
    private final ValueAtQuantileMarshaler[] quantileValues;
    private final KeyValueMarshaler[] attributes;

    static SummaryDataPointMarshaler[] createRepeated(Collection<SummaryPointData> collection) {
        SummaryDataPointMarshaler[] summaryDataPointMarshalerArray = new SummaryDataPointMarshaler[collection.size()];
        int n2 = 0;
        for (SummaryPointData summaryPointData : collection) {
            summaryDataPointMarshalerArray[n2++] = SummaryDataPointMarshaler.create(summaryPointData);
        }
        return summaryDataPointMarshalerArray;
    }

    static SummaryDataPointMarshaler create(SummaryPointData summaryPointData) {
        ValueAtQuantileMarshaler[] valueAtQuantileMarshalerArray = ValueAtQuantileMarshaler.createRepeated(summaryPointData.getValues());
        KeyValueMarshaler[] keyValueMarshalerArray = KeyValueMarshaler.createRepeated(summaryPointData.getAttributes());
        return new SummaryDataPointMarshaler(summaryPointData.getStartEpochNanos(), summaryPointData.getEpochNanos(), summaryPointData.getCount(), summaryPointData.getSum(), valueAtQuantileMarshalerArray, keyValueMarshalerArray);
    }

    private SummaryDataPointMarshaler(long l2, long l3, long l4, double d2, ValueAtQuantileMarshaler[] valueAtQuantileMarshalerArray, KeyValueMarshaler[] keyValueMarshalerArray) {
        super(SummaryDataPointMarshaler.calculateSize(l2, l3, l4, d2, valueAtQuantileMarshalerArray, keyValueMarshalerArray));
        this.startTimeUnixNano = l2;
        this.timeUnixNano = l3;
        this.count = l4;
        this.sum = d2;
        this.quantileValues = valueAtQuantileMarshalerArray;
        this.attributes = keyValueMarshalerArray;
    }

    @Override
    public void writeTo(Serializer serializer) throws IOException {
        serializer.serializeFixed64(SummaryDataPoint.START_TIME_UNIX_NANO, this.startTimeUnixNano);
        serializer.serializeFixed64(SummaryDataPoint.TIME_UNIX_NANO, this.timeUnixNano);
        serializer.serializeFixed64(SummaryDataPoint.COUNT, this.count);
        serializer.serializeDouble(SummaryDataPoint.SUM, this.sum);
        serializer.serializeRepeatedMessage(SummaryDataPoint.QUANTILE_VALUES, this.quantileValues);
        serializer.serializeRepeatedMessage(SummaryDataPoint.ATTRIBUTES, this.attributes);
    }

    private static int calculateSize(long l2, long l3, long l4, double d2, ValueAtQuantileMarshaler[] valueAtQuantileMarshalerArray, KeyValueMarshaler[] keyValueMarshalerArray) {
        int n2 = 0;
        n2 += MarshalerUtil.sizeFixed64(SummaryDataPoint.START_TIME_UNIX_NANO, l2);
        n2 += MarshalerUtil.sizeFixed64(SummaryDataPoint.TIME_UNIX_NANO, l3);
        n2 += MarshalerUtil.sizeFixed64(SummaryDataPoint.COUNT, l4);
        n2 += MarshalerUtil.sizeDouble(SummaryDataPoint.SUM, d2);
        n2 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)SummaryDataPoint.QUANTILE_VALUES, (Marshaler[])valueAtQuantileMarshalerArray);
        return n2 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)SummaryDataPoint.ATTRIBUTES, (Marshaler[])keyValueMarshalerArray);
    }
}

