/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.trace;

import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.data.SpanData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcSpanExporter
implements SpanExporter {
    private final GrpcExporterBuilder<TraceRequestMarshaler> builder;
    private final GrpcExporter<TraceRequestMarshaler> delegate;

    public static OtlpGrpcSpanExporter getDefault() {
        return OtlpGrpcSpanExporter.builder().build();
    }

    public static OtlpGrpcSpanExporterBuilder builder() {
        return new OtlpGrpcSpanExporterBuilder();
    }

    OtlpGrpcSpanExporter(GrpcExporterBuilder<TraceRequestMarshaler> grpcExporterBuilder, GrpcExporter<TraceRequestMarshaler> grpcExporter) {
        this.builder = grpcExporterBuilder;
        this.delegate = grpcExporter;
    }

    public OtlpGrpcSpanExporterBuilder toBuilder() {
        return new OtlpGrpcSpanExporterBuilder(this.builder.copy());
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> collection) {
        TraceRequestMarshaler traceRequestMarshaler = TraceRequestMarshaler.create(collection);
        return this.delegate.export(traceRequestMarshaler, collection.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        return "OtlpGrpcSpanExporter{" + this.builder.toString(false) + "}";
    }
}

