/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal;

import com.contrastsecurity.agent.logging.log4j2.f;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.Clock;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.RateLimiter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class ThrottlingLogger {
    private static final double RATE_LIMIT = 5.0;
    private static final double THROTTLED_RATE_LIMIT = 1.0;
    private static final TimeUnit rateTimeUnit = TimeUnit.MINUTES;
    private final f delegate;
    private final AtomicBoolean throttled = new AtomicBoolean(false);
    private final RateLimiter fastRateLimiter;
    private final RateLimiter throttledRateLimiter;

    public ThrottlingLogger(f f2) {
        this(f2, Clock.getDefault());
    }

    ThrottlingLogger(f f2, Clock clock) {
        this.delegate = f2;
        this.fastRateLimiter = new RateLimiter(5.0 / (double)rateTimeUnit.toSeconds(1L), 5.0, clock);
        this.throttledRateLimiter = new RateLimiter(5.0 / (double)rateTimeUnit.toSeconds(1L), 1.0, clock);
    }

    public void log(f.a a2, String string) {
        this.log(a2, string, null);
    }

    public void log(f.a a2, String string, @Nullable Throwable throwable) {
        if (!this.isLoggable(a2)) {
            return;
        }
        if (this.throttled.get()) {
            if (this.throttledRateLimiter.trySpend(1.0)) {
                this.doLog(a2, string, throwable);
            }
            return;
        }
        if (this.fastRateLimiter.trySpend(1.0)) {
            this.doLog(a2, string, throwable);
            return;
        }
        if (this.throttled.compareAndSet(false, true)) {
            this.throttledRateLimiter.trySpend(1.0);
            this.delegate.a(a2, "Too many log messages detected. Will only log once per minute from now on.");
            this.doLog(a2, string, throwable);
        }
    }

    private void doLog(f.a a2, String string, @Nullable Throwable throwable) {
        if (throwable != null) {
            this.delegate.a(a2, string, throwable);
        } else {
            this.delegate.a(a2, string);
        }
    }

    public boolean isLoggable(f.a a2) {
        return this.delegate.a(a2);
    }
}

