/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs;

import com.contrastsecurity.agent.logging.log4j2.f;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.logs.Logger;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.logs.LoggerBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.logs.LoggerProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.Clock;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.ComponentRegistry;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.LogLimits;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.LogRecordProcessor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.LoggerSharedState;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.NoopLogRecordProcessor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.SdkLogger;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.SdkLoggerBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.resources.Resource;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class SdkLoggerProvider
implements LoggerProvider,
Closeable {
    static final String DEFAULT_LOGGER_NAME = "unknown";
    private static final f LOGGER = f.a(SdkLoggerProvider.class.getName());
    private final LoggerSharedState sharedState;
    private final ComponentRegistry<SdkLogger> loggerComponentRegistry;
    private final boolean isNoopLogRecordProcessor;

    public static SdkLoggerProviderBuilder builder() {
        return new SdkLoggerProviderBuilder();
    }

    SdkLoggerProvider(Resource resource, Supplier<LogLimits> supplier, List<LogRecordProcessor> list, Clock clock) {
        LogRecordProcessor logRecordProcessor = LogRecordProcessor.composite(list);
        this.sharedState = new LoggerSharedState(resource, supplier, logRecordProcessor, clock);
        this.loggerComponentRegistry = new ComponentRegistry<SdkLogger>(instrumentationScopeInfo -> new SdkLogger(this.sharedState, (InstrumentationScopeInfo)instrumentationScopeInfo));
        this.isNoopLogRecordProcessor = logRecordProcessor instanceof NoopLogRecordProcessor;
    }

    @Override
    public Logger get(String string) {
        return this.loggerComponentRegistry.get(SdkLoggerProvider.instrumentationNameOrDefault(string), null, null, Attributes.empty());
    }

    @Override
    public LoggerBuilder loggerBuilder(String string) {
        if (this.isNoopLogRecordProcessor) {
            return LoggerProvider.noop().loggerBuilder(string);
        }
        return new SdkLoggerBuilder(this.loggerComponentRegistry, SdkLoggerProvider.instrumentationNameOrDefault(string));
    }

    private static String instrumentationNameOrDefault(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            LOGGER.f("Logger requested without instrumentation scope name.");
            return DEFAULT_LOGGER_NAME;
        }
        return string;
    }

    public CompletableResultCode forceFlush() {
        return this.sharedState.getLogRecordProcessor().forceFlush();
    }

    public CompletableResultCode shutdown() {
        if (this.sharedState.hasBeenShutdown()) {
            LOGGER.a(f.a.d, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.sharedState.shutdown();
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "SdkLoggerProvider{clock=" + this.sharedState.getClock() + ", resource=" + this.sharedState.getResource() + ", logLimits=" + this.sharedState.getLogLimits() + ", logRecordProcessor=" + this.sharedState.getLogRecordProcessor() + '}';
    }
}

