/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics;

import com.contrastsecurity.agent.logging.log4j2.f;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.DoubleCounter;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.DoubleCounterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.ObservableDoubleCounter;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.ThrottlingLogger;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.AbstractInstrument;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.InstrumentType;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.InstrumentValueType;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.function.Consumer;

final class SdkDoubleCounter
extends AbstractInstrument
implements DoubleCounter {
    private static final f logger = f.a(SdkDoubleCounter.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final WriteableMetricStorage storage;

    private SdkDoubleCounter(InstrumentDescriptor instrumentDescriptor, WriteableMetricStorage writeableMetricStorage) {
        super(instrumentDescriptor);
        this.storage = writeableMetricStorage;
    }

    @Override
    public void add(double d2, Attributes attributes, Context context) {
        if (d2 < 0.0) {
            this.throttlingLogger.log(f.a.c, "Counters can only increase. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordDouble(d2, attributes, context);
    }

    @Override
    public void add(double d2, Attributes attributes) {
        this.add(d2, attributes, Context.current());
    }

    @Override
    public void add(double d2) {
        this.add(d2, Attributes.empty());
    }

    static final class SdkDoubleCounterBuilder
    extends AbstractInstrumentBuilder<SdkDoubleCounterBuilder>
    implements DoubleCounterBuilder {
        SdkDoubleCounterBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String string, String string2, String string3, Advice advice) {
            super(meterProviderSharedState, meterSharedState, InstrumentType.COUNTER, InstrumentValueType.DOUBLE, string, string2, string3, advice);
        }

        @Override
        protected SdkDoubleCounterBuilder getThis() {
            return this;
        }

        @Override
        public SdkDoubleCounter build() {
            return this.buildSynchronousInstrument((instrumentDescriptor, writeableMetricStorage) -> new SdkDoubleCounter((InstrumentDescriptor)instrumentDescriptor, (WriteableMetricStorage)writeableMetricStorage));
        }

        @Override
        public ObservableDoubleCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> consumer) {
            return this.registerDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_COUNTER, consumer);
        }

        @Override
        public ObservableDoubleMeasurement buildObserver() {
            return this.buildObservableMeasurement(InstrumentType.OBSERVABLE_COUNTER);
        }
    }
}

