/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator;

import com.contrastsecurity.thirdparty.com.google.auto.value.AutoValue;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.ExponentialHistogramBuckets;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.ExponentialHistogramPointData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.MetricData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.AutoValue_DoubleBase2ExponentialHistogramAggregator_EmptyExponentialHistogramBuckets;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.DoubleBase2ExponentialHistogramBuckets;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.data.ImmutableExponentialHistogramData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.data.ImmutableExponentialHistogramPointData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.resources.Resource;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class DoubleBase2ExponentialHistogramAggregator
implements Aggregator<ExponentialHistogramPointData, DoubleExemplarData> {
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;
    private final int maxBuckets;
    private final int maxScale;

    public DoubleBase2ExponentialHistogramAggregator(Supplier<ExemplarReservoir<DoubleExemplarData>> supplier, int n2, int n3) {
        this.reservoirSupplier = supplier;
        this.maxBuckets = n2;
        this.maxScale = n3;
    }

    @Override
    public AggregatorHandle<ExponentialHistogramPointData, DoubleExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get(), this.maxBuckets, this.maxScale);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor metricDescriptor, Collection<ExponentialHistogramPointData> collection, AggregationTemporality aggregationTemporality) {
        return ImmutableMetricData.createExponentialHistogram(resource, instrumentationScopeInfo, metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.getSourceInstrument().getUnit(), ImmutableExponentialHistogramData.create(aggregationTemporality, collection));
    }

    static final class Handle
    extends AggregatorHandle<ExponentialHistogramPointData, DoubleExemplarData> {
        private final int maxBuckets;
        private final int maxScale;
        @Nullable
        private DoubleBase2ExponentialHistogramBuckets positiveBuckets;
        @Nullable
        private DoubleBase2ExponentialHistogramBuckets negativeBuckets;
        private long zeroCount;
        private double sum;
        private double min;
        private double max;
        private long count;
        private int currentScale;

        Handle(ExemplarReservoir<DoubleExemplarData> exemplarReservoir, int n2, int n3) {
            super(exemplarReservoir);
            this.maxBuckets = n2;
            this.maxScale = n3;
            this.sum = 0.0;
            this.zeroCount = 0L;
            this.min = Double.MAX_VALUE;
            this.max = -1.0;
            this.count = 0L;
            this.currentScale = n3;
        }

        @Override
        protected synchronized ExponentialHistogramPointData doAggregateThenMaybeReset(long l2, long l3, Attributes attributes, List<DoubleExemplarData> list, boolean bl2) {
            ExponentialHistogramPointData exponentialHistogramPointData = ImmutableExponentialHistogramPointData.create(this.currentScale, this.sum, this.zeroCount, this.count > 0L, this.min, this.count > 0L, this.max, this.resolveBuckets(this.positiveBuckets, this.currentScale, bl2), this.resolveBuckets(this.negativeBuckets, this.currentScale, bl2), l2, l3, attributes, list);
            if (bl2) {
                this.sum = 0.0;
                this.zeroCount = 0L;
                this.min = Double.MAX_VALUE;
                this.max = -1.0;
                this.count = 0L;
                this.currentScale = this.maxScale;
            }
            return exponentialHistogramPointData;
        }

        private ExponentialHistogramBuckets resolveBuckets(@Nullable DoubleBase2ExponentialHistogramBuckets doubleBase2ExponentialHistogramBuckets, int n2, boolean bl2) {
            if (doubleBase2ExponentialHistogramBuckets == null) {
                return EmptyExponentialHistogramBuckets.get(n2);
            }
            DoubleBase2ExponentialHistogramBuckets doubleBase2ExponentialHistogramBuckets2 = doubleBase2ExponentialHistogramBuckets.copy();
            if (bl2) {
                doubleBase2ExponentialHistogramBuckets.clear(this.maxScale);
            }
            return doubleBase2ExponentialHistogramBuckets2;
        }

        @Override
        protected synchronized void doRecordDouble(double d2) {
            DoubleBase2ExponentialHistogramBuckets doubleBase2ExponentialHistogramBuckets;
            if (!Double.isFinite(d2)) {
                return;
            }
            this.sum += d2;
            this.min = Math.min(this.min, d2);
            this.max = Math.max(this.max, d2);
            ++this.count;
            int n2 = Double.compare(d2, 0.0);
            if (n2 == 0) {
                ++this.zeroCount;
                return;
            }
            if (n2 > 0) {
                if (this.positiveBuckets == null) {
                    this.positiveBuckets = new DoubleBase2ExponentialHistogramBuckets(this.currentScale, this.maxBuckets);
                }
                doubleBase2ExponentialHistogramBuckets = this.positiveBuckets;
            } else {
                if (this.negativeBuckets == null) {
                    this.negativeBuckets = new DoubleBase2ExponentialHistogramBuckets(this.currentScale, this.maxBuckets);
                }
                doubleBase2ExponentialHistogramBuckets = this.negativeBuckets;
            }
            if (!doubleBase2ExponentialHistogramBuckets.record(d2)) {
                this.downScale(doubleBase2ExponentialHistogramBuckets.getScaleReduction(d2));
                doubleBase2ExponentialHistogramBuckets.record(d2);
            }
        }

        @Override
        protected void doRecordLong(long l2) {
            this.doRecordDouble(l2);
        }

        void downScale(int n2) {
            if (this.positiveBuckets != null) {
                this.positiveBuckets.downscale(n2);
                this.currentScale = this.positiveBuckets.getScale();
            }
            if (this.negativeBuckets != null) {
                this.negativeBuckets.downscale(n2);
                this.currentScale = this.negativeBuckets.getScale();
            }
        }
    }

    @AutoValue
    static abstract class EmptyExponentialHistogramBuckets
    implements ExponentialHistogramBuckets {
        private static final Map<Integer, ExponentialHistogramBuckets> ZERO_BUCKETS = new ConcurrentHashMap<Integer, ExponentialHistogramBuckets>();

        EmptyExponentialHistogramBuckets() {
        }

        static ExponentialHistogramBuckets get(int n3) {
            return ZERO_BUCKETS.computeIfAbsent(n3, n2 -> new AutoValue_DoubleBase2ExponentialHistogramAggregator_EmptyExponentialHistogramBuckets((int)n2, 0, Collections.emptyList(), 0L));
        }
    }
}

