/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator;

import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.PrimitiveLongList;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.ExponentialHistogramBuckets;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.AdaptingCircularBufferCounter;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.Base2ExponentialHistogramIndexer;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

final class DoubleBase2ExponentialHistogramBuckets
implements ExponentialHistogramBuckets {
    private AdaptingCircularBufferCounter counts;
    private int scale;
    private Base2ExponentialHistogramIndexer base2ExponentialHistogramIndexer;
    private long totalCount;

    DoubleBase2ExponentialHistogramBuckets(int n2, int n3) {
        this.counts = new AdaptingCircularBufferCounter(n3);
        this.scale = n2;
        this.base2ExponentialHistogramIndexer = Base2ExponentialHistogramIndexer.get(this.scale);
        this.totalCount = 0L;
    }

    DoubleBase2ExponentialHistogramBuckets(DoubleBase2ExponentialHistogramBuckets doubleBase2ExponentialHistogramBuckets) {
        this.counts = new AdaptingCircularBufferCounter(doubleBase2ExponentialHistogramBuckets.counts);
        this.scale = doubleBase2ExponentialHistogramBuckets.scale;
        this.base2ExponentialHistogramIndexer = doubleBase2ExponentialHistogramBuckets.base2ExponentialHistogramIndexer;
        this.totalCount = doubleBase2ExponentialHistogramBuckets.totalCount;
    }

    DoubleBase2ExponentialHistogramBuckets copy() {
        return new DoubleBase2ExponentialHistogramBuckets(this);
    }

    void clear(int n2) {
        this.totalCount = 0L;
        this.scale = n2;
        this.base2ExponentialHistogramIndexer = Base2ExponentialHistogramIndexer.get(this.scale);
        this.counts.clear();
    }

    boolean record(double d2) {
        if (d2 == 0.0) {
            throw new IllegalStateException("Illegal attempted recording of zero at bucket level.");
        }
        int n2 = this.base2ExponentialHistogramIndexer.computeIndex(d2);
        boolean bl2 = this.counts.increment(n2, 1L);
        if (bl2) {
            ++this.totalCount;
        }
        return bl2;
    }

    @Override
    public int getOffset() {
        if (this.counts.isEmpty()) {
            return 0;
        }
        return this.counts.getIndexStart();
    }

    @Override
    public List<Long> getBucketCounts() {
        if (this.counts.isEmpty()) {
            return Collections.emptyList();
        }
        int n2 = this.counts.getIndexEnd() - this.counts.getIndexStart() + 1;
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = this.counts.get(i2 + this.counts.getIndexStart());
        }
        return PrimitiveLongList.wrap(lArray);
    }

    @Override
    public long getTotalCount() {
        return this.totalCount;
    }

    void downscale(int n2) {
        if (n2 == 0) {
            return;
        }
        if (n2 < 0) {
            throw new IllegalStateException("Cannot downscale by negative amount. Was given " + n2 + ".");
        }
        if (!this.counts.isEmpty()) {
            AdaptingCircularBufferCounter adaptingCircularBufferCounter = new AdaptingCircularBufferCounter(this.counts);
            adaptingCircularBufferCounter.clear();
            for (int i2 = this.counts.getIndexStart(); i2 <= this.counts.getIndexEnd(); ++i2) {
                long l2 = this.counts.get(i2);
                if (l2 <= 0L || adaptingCircularBufferCounter.increment(i2 >> n2, l2)) continue;
                throw new IllegalStateException("Failed to create new downscaled buckets.");
            }
            this.counts = adaptingCircularBufferCounter;
        }
        this.scale -= n2;
        this.base2ExponentialHistogramIndexer = Base2ExponentialHistogramIndexer.get(this.scale);
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    int getScaleReduction(double d2) {
        long l2 = this.base2ExponentialHistogramIndexer.computeIndex(d2);
        long l3 = Math.min(l2, (long)this.counts.getIndexStart());
        long l4 = Math.max(l2, (long)this.counts.getIndexEnd());
        return this.getScaleReduction(l3, l4);
    }

    int getScaleReduction(long l2, long l3) {
        int n2 = 0;
        while (l3 - l2 + 1L > (long)this.counts.getMaxSize()) {
            l2 >>= 1;
            l3 >>= 1;
            ++n2;
        }
        return n2;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof DoubleBase2ExponentialHistogramBuckets)) {
            return false;
        }
        DoubleBase2ExponentialHistogramBuckets doubleBase2ExponentialHistogramBuckets = (DoubleBase2ExponentialHistogramBuckets)object;
        return this.scale == doubleBase2ExponentialHistogramBuckets.scale && this.sameBucketCounts(doubleBase2ExponentialHistogramBuckets);
    }

    private boolean sameBucketCounts(DoubleBase2ExponentialHistogramBuckets doubleBase2ExponentialHistogramBuckets) {
        if (this.totalCount != doubleBase2ExponentialHistogramBuckets.totalCount) {
            return false;
        }
        int n2 = Math.min(this.counts.getIndexStart(), doubleBase2ExponentialHistogramBuckets.counts.getIndexStart());
        if (n2 == Integer.MIN_VALUE) {
            n2 = Math.max(this.counts.getIndexStart(), doubleBase2ExponentialHistogramBuckets.counts.getIndexStart());
        }
        int n3 = Math.max(this.counts.getIndexEnd(), doubleBase2ExponentialHistogramBuckets.counts.getIndexEnd());
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (this.counts.get(i2) == doubleBase2ExponentialHistogramBuckets.counts.get(i2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 1;
        n2 *= 1000003;
        for (int i2 = this.counts.getIndexStart(); i2 <= this.counts.getIndexEnd(); ++i2) {
            long l2 = this.counts.get(i2);
            if (l2 == 0L) continue;
            n2 ^= i2;
            n2 *= 1000003;
            n2 = (int)((long)n2 ^ l2);
            n2 *= 1000003;
        }
        return n2 ^= this.scale;
    }

    public String toString() {
        return "DoubleExponentialHistogramBuckets{scale: " + this.scale + ", offset: " + this.getOffset() + ", counts: " + this.counts + " }";
    }
}

