/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.debug;

import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.debug.SourceInfo;

final class StackTraceSourceInfo
implements SourceInfo {
    private final StackTraceElement[] stackTraceElements;

    StackTraceSourceInfo(StackTraceElement[] stackTraceElementArray) {
        this.stackTraceElements = stackTraceElementArray;
    }

    @Override
    public String shortDebugString() {
        if (this.stackTraceElements.length > 0) {
            for (StackTraceElement stackTraceElement : this.stackTraceElements) {
                if (!StackTraceSourceInfo.isInterestingStackTrace(stackTraceElement)) continue;
                return String.format("%s:%d", stackTraceElement.getFileName(), stackTraceElement.getLineNumber());
            }
        }
        return "unknown source";
    }

    @Override
    public String multiLineDebugString() {
        if (this.stackTraceElements.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (StackTraceElement stackTraceElement : this.stackTraceElements) {
                if (!StackTraceSourceInfo.isInterestingStackTrace(stackTraceElement)) continue;
                stringBuilder.append("\tat ").append(stackTraceElement).append("\n");
            }
            return stringBuilder.toString();
        }
        return "\tat unknown source";
    }

    private static boolean isInterestingStackTrace(StackTraceElement stackTraceElement) {
        return !stackTraceElement.getClassName().startsWith("com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics") && !stackTraceElement.getClassName().startsWith("java.lang");
    }
}

