/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view;

import com.contrastsecurity.agent.logging.log4j2.f;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.Aggregation;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.InstrumentSelector;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.InstrumentType;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.View;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.AggregationUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.debug.SourceInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.export.CardinalityLimitSelector;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view.NoopAttributesProcessor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.internal.view.RegisteredView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ViewRegistry {
    static final View DEFAULT_VIEW = View.builder().build();
    static final RegisteredView DEFAULT_REGISTERED_VIEW = RegisteredView.create(InstrumentSelector.builder().setName("*").build(), DEFAULT_VIEW, NoopAttributesProcessor.NOOP, 2000, SourceInfo.noSourceInfo());
    private static final f logger = f.a(ViewRegistry.class.getName());
    private final Map<InstrumentType, RegisteredView> instrumentDefaultRegisteredView = new HashMap<InstrumentType, RegisteredView>();
    private final List<RegisteredView> registeredViews;

    ViewRegistry(DefaultAggregationSelector defaultAggregationSelector, CardinalityLimitSelector cardinalityLimitSelector, List<RegisteredView> list) {
        for (InstrumentType instrumentType : InstrumentType.values()) {
            this.instrumentDefaultRegisteredView.put(instrumentType, RegisteredView.create(InstrumentSelector.builder().setName("*").build(), View.builder().setAggregation(defaultAggregationSelector.getDefaultAggregation(instrumentType)).build(), AttributesProcessor.noop(), cardinalityLimitSelector.getCardinalityLimit(instrumentType), SourceInfo.noSourceInfo()));
        }
        this.registeredViews = list;
    }

    public static ViewRegistry create(DefaultAggregationSelector defaultAggregationSelector, CardinalityLimitSelector cardinalityLimitSelector, List<RegisteredView> list) {
        return new ViewRegistry(defaultAggregationSelector, cardinalityLimitSelector, new ArrayList<RegisteredView>(list));
    }

    public static ViewRegistry create() {
        return ViewRegistry.create(instrumentType -> Aggregation.defaultAggregation(), CardinalityLimitSelector.defaultCardinalityLimitSelector(), Collections.emptyList());
    }

    public List<RegisteredView> findViews(InstrumentDescriptor instrumentDescriptor, InstrumentationScopeInfo instrumentationScopeInfo) {
        ArrayList<RegisteredView> arrayList = new ArrayList<RegisteredView>();
        for (RegisteredView object2 : this.registeredViews) {
            if (!ViewRegistry.matchesSelector(object2.getInstrumentSelector(), instrumentDescriptor, instrumentationScopeInfo)) continue;
            AggregatorFactory aggregatorFactory = (AggregatorFactory)((Object)object2.getView().getAggregation());
            if (aggregatorFactory.isCompatibleWithInstrument(instrumentDescriptor)) {
                arrayList.add(object2);
                continue;
            }
            logger.a(f.a.c, "View aggregation " + AggregationUtil.aggregationName(object2.getView().getAggregation()) + " is incompatible with instrument " + instrumentDescriptor.getName() + " of type " + (Object)((Object)instrumentDescriptor.getType()));
        }
        if (!arrayList.isEmpty()) {
            return Collections.unmodifiableList(arrayList);
        }
        RegisteredView registeredView = Objects.requireNonNull(this.instrumentDefaultRegisteredView.get((Object)instrumentDescriptor.getType()));
        AggregatorFactory aggregatorFactory = (AggregatorFactory)((Object)registeredView.getView().getAggregation());
        if (aggregatorFactory.isCompatibleWithInstrument(instrumentDescriptor)) {
            return Collections.singletonList(registeredView);
        }
        logger.a(f.a.c, "Instrument default aggregation " + AggregationUtil.aggregationName(registeredView.getView().getAggregation()) + " is incompatible with instrument " + instrumentDescriptor.getName() + " of type " + (Object)((Object)instrumentDescriptor.getType()));
        return Collections.singletonList(DEFAULT_REGISTERED_VIEW);
    }

    private static boolean matchesSelector(InstrumentSelector instrumentSelector, InstrumentDescriptor instrumentDescriptor, InstrumentationScopeInfo instrumentationScopeInfo) {
        if (instrumentSelector.getInstrumentType() != null && instrumentSelector.getInstrumentType() != instrumentDescriptor.getType()) {
            return false;
        }
        if (instrumentSelector.getInstrumentUnit() != null && !instrumentSelector.getInstrumentUnit().equals(instrumentDescriptor.getUnit())) {
            return false;
        }
        if (instrumentSelector.getInstrumentName() != null && !ViewRegistry.toGlobPatternPredicate(instrumentSelector.getInstrumentName()).test(instrumentDescriptor.getName())) {
            return false;
        }
        return ViewRegistry.matchesMeter(instrumentSelector, instrumentationScopeInfo);
    }

    private static boolean matchesMeter(InstrumentSelector instrumentSelector, InstrumentationScopeInfo instrumentationScopeInfo) {
        if (instrumentSelector.getMeterName() != null && !instrumentSelector.getMeterName().equals(instrumentationScopeInfo.getName())) {
            return false;
        }
        if (instrumentSelector.getMeterVersion() != null && !instrumentSelector.getMeterVersion().equals(instrumentationScopeInfo.getVersion())) {
            return false;
        }
        return instrumentSelector.getMeterSchemaUrl() == null || instrumentSelector.getMeterSchemaUrl().equals(instrumentationScopeInfo.getSchemaUrl());
    }

    static Predicate<String> toGlobPatternPredicate(String string2) {
        if (string2.equals("*")) {
            return string -> true;
        }
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            if (c2 != '*' && c2 != '?') continue;
            Pattern pattern = ViewRegistry.toRegexPattern(string2);
            return string -> pattern.matcher((CharSequence)string).matches();
        }
        return string2::equalsIgnoreCase;
    }

    private static Pattern toRegexPattern(String string) {
        int n2 = -1;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '*' || c2 == '?') {
                if (n2 != -1) {
                    stringBuilder.append(Pattern.quote(string.substring(n2, i2)));
                    n2 = -1;
                }
                if (c2 == '*') {
                    stringBuilder.append(".*");
                    continue;
                }
                stringBuilder.append(".");
                continue;
            }
            if (n2 != -1) continue;
            n2 = i2;
        }
        if (n2 != -1) {
            stringBuilder.append(Pattern.quote(string.substring(n2)));
        }
        return Pattern.compile(stringBuilder.toString());
    }
}

