/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.Utils;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.SpanLimits;

public final class SpanLimitsBuilder {
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES = 128;
    private static final int DEFAULT_SPAN_MAX_NUM_EVENTS = 128;
    private static final int DEFAULT_SPAN_MAX_NUM_LINKS = 128;
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES_PER_EVENT = 128;
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES_PER_LINK = 128;
    private int maxNumAttributes = 128;
    private int maxNumEvents = 128;
    private int maxNumLinks = 128;
    private int maxNumAttributesPerEvent = 128;
    private int maxNumAttributesPerLink = 128;
    private int maxAttributeValueLength = Integer.MAX_VALUE;

    SpanLimitsBuilder() {
    }

    public SpanLimitsBuilder setMaxNumberOfAttributes(int n2) {
        Utils.checkArgument(n2 > 0, "maxNumberOfAttributes must be greater than 0");
        this.maxNumAttributes = n2;
        return this;
    }

    public SpanLimitsBuilder setMaxNumberOfEvents(int n2) {
        Utils.checkArgument(n2 > 0, "maxNumberOfEvents must be greater than 0");
        this.maxNumEvents = n2;
        return this;
    }

    public SpanLimitsBuilder setMaxNumberOfLinks(int n2) {
        Utils.checkArgument(n2 > 0, "maxNumberOfLinks must be greater than 0");
        this.maxNumLinks = n2;
        return this;
    }

    public SpanLimitsBuilder setMaxNumberOfAttributesPerEvent(int n2) {
        Utils.checkArgument(n2 > 0, "maxNumberOfAttributesPerEvent must be greater than 0");
        this.maxNumAttributesPerEvent = n2;
        return this;
    }

    public SpanLimitsBuilder setMaxNumberOfAttributesPerLink(int n2) {
        Utils.checkArgument(n2 > 0, "maxNumberOfAttributesPerLink must be greater than 0");
        this.maxNumAttributesPerLink = n2;
        return this;
    }

    public SpanLimitsBuilder setMaxAttributeValueLength(int n2) {
        Utils.checkArgument(n2 > -1, "maxAttributeValueLength must be non-negative");
        this.maxAttributeValueLength = n2;
        return this;
    }

    public SpanLimits build() {
        return SpanLimits.create(this.maxNumAttributes, this.maxNumEvents, this.maxNumLinks, this.maxNumAttributesPerEvent, this.maxNumAttributesPerLink, this.maxAttributeValueLength);
    }
}

