/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.samplers;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.Span;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.SpanContext;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.SpanKind;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.data.LinkData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.samplers.Sampler;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ParentBasedSampler
implements Sampler {
    private final Sampler root;
    private final Sampler remoteParentSampled;
    private final Sampler remoteParentNotSampled;
    private final Sampler localParentSampled;
    private final Sampler localParentNotSampled;

    ParentBasedSampler(Sampler sampler, @Nullable Sampler sampler2, @Nullable Sampler sampler3, @Nullable Sampler sampler4, @Nullable Sampler sampler5) {
        this.root = sampler;
        this.remoteParentSampled = sampler2 == null ? Sampler.alwaysOn() : sampler2;
        this.remoteParentNotSampled = sampler3 == null ? Sampler.alwaysOff() : sampler3;
        this.localParentSampled = sampler4 == null ? Sampler.alwaysOn() : sampler4;
        this.localParentNotSampled = sampler5 == null ? Sampler.alwaysOff() : sampler5;
    }

    @Override
    public SamplingResult shouldSample(Context context, String string, String string2, SpanKind spanKind, Attributes attributes, List<LinkData> list) {
        SpanContext spanContext = Span.fromContext(context).getSpanContext();
        if (!spanContext.isValid()) {
            return this.root.shouldSample(context, string, string2, spanKind, attributes, list);
        }
        if (spanContext.isRemote()) {
            return spanContext.isSampled() ? this.remoteParentSampled.shouldSample(context, string, string2, spanKind, attributes, list) : this.remoteParentNotSampled.shouldSample(context, string, string2, spanKind, attributes, list);
        }
        return spanContext.isSampled() ? this.localParentSampled.shouldSample(context, string, string2, spanKind, attributes, list) : this.localParentNotSampled.shouldSample(context, string, string2, spanKind, attributes, list);
    }

    @Override
    public String getDescription() {
        return String.format("ParentBased{root:%s,remoteParentSampled:%s,remoteParentNotSampled:%s,localParentSampled:%s,localParentNotSampled:%s}", this.root.getDescription(), this.remoteParentSampled.getDescription(), this.remoteParentNotSampled.getDescription(), this.localParentSampled.getDescription(), this.localParentNotSampled.getDescription());
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ParentBasedSampler)) {
            return false;
        }
        ParentBasedSampler parentBasedSampler = (ParentBasedSampler)object;
        return this.root.equals(parentBasedSampler.root) && this.remoteParentSampled.equals(parentBasedSampler.remoteParentSampled) && this.remoteParentNotSampled.equals(parentBasedSampler.remoteParentNotSampled) && this.localParentSampled.equals(parentBasedSampler.localParentSampled) && this.localParentNotSampled.equals(parentBasedSampler.localParentNotSampled);
    }

    public int hashCode() {
        int n2 = this.root.hashCode();
        n2 = 31 * n2 + this.remoteParentSampled.hashCode();
        n2 = 31 * n2 + this.remoteParentNotSampled.hashCode();
        n2 = 31 * n2 + this.localParentSampled.hashCode();
        n2 = 31 * n2 + this.localParentNotSampled.hashCode();
        return n2;
    }
}

