/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.LatencyUtils;

import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import java.util.Comparator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TimeServices {
    public static final boolean useActualTime;
    private static long currentTime;
    private static final Object timeUpdateMonitor;

    public static long nanoTime() {
        if (useActualTime) {
            return System.nanoTime();
        }
        return currentTime;
    }

    public static long currentTimeMillis() {
        if (useActualTime) {
            return System.currentTimeMillis();
        }
        return currentTime / 1000000L;
    }

    public static void sleepMsecs(long l2) {
        try {
            if (useActualTime) {
                Thread.sleep(l2);
            } else {
                TimeServices.waitUntilTime(currentTime + l2 * 1000000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void sleepNanos(long l2) {
        try {
            if (useActualTime) {
                TimeUnit.NANOSECONDS.sleep(l2);
            } else {
                TimeServices.waitUntilTime(currentTime + l2);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitUntilTime(long l2) throws InterruptedException {
        Object object = timeUpdateMonitor;
        synchronized (object) {
            while (l2 > currentTime) {
                timeUpdateMonitor.wait();
            }
        }
    }

    public static void moveTimeForward(long l2) throws InterruptedException {
        TimeServices.setCurrentTime(currentTime + l2);
    }

    public static void moveTimeForwardMsec(long l2) throws InterruptedException {
        TimeServices.moveTimeForward(l2 * 1000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentTime(long l2) throws InterruptedException {
        if (l2 < TimeServices.nanoTime()) {
            throw new IllegalStateException("Can't set current time to the past.");
        }
        if (useActualTime) {
            while (l2 > TimeServices.nanoTime()) {
                TimeUnit.NANOSECONDS.sleep(l2 - TimeServices.nanoTime());
            }
            return;
        }
        while (currentTime < l2) {
            long l3 = Math.min(l2 - currentTime, 5000000L);
            currentTime += l3;
            Object object = timeUpdateMonitor;
            synchronized (object) {
                timeUpdateMonitor.notifyAll();
                TimeUnit.NANOSECONDS.sleep(50000L);
            }
        }
    }

    static {
        timeUpdateMonitor = new Object();
        String string = System.getProperty("LatencyUtils.useActualTime", "true");
        useActualTime = !string.equals("false");
    }

    public static class ScheduledExecutor {
        private final ScheduledThreadPoolExecutor actualExecutor;
        final MyExecutorThread internalExecutorThread;
        final PriorityBlockingQueue<RunnableTaskEntry> taskEntries;
        private static CompareRunnableTaskEntryByStartTime compareRunnableTaskEntryByStartTime = new CompareRunnableTaskEntryByStartTime();

        ScheduledExecutor() {
            if (useActualTime) {
                this.actualExecutor = new ScheduledThreadPoolExecutor(1);
                this.internalExecutorThread = null;
                this.taskEntries = null;
            } else {
                this.actualExecutor = null;
                this.taskEntries = new PriorityBlockingQueue<RunnableTaskEntry>(10000, compareRunnableTaskEntryByStartTime);
                this.internalExecutorThread = new MyExecutorThread();
                this.internalExecutorThread.setDaemon(true);
                this.internalExecutorThread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleAtFixedRate(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
            if (useActualTime) {
                this.actualExecutor.scheduleAtFixedRate(runnable, l2, l3, timeUnit);
                return;
            }
            long l4 = currentTime + TimeUnit.NANOSECONDS.convert(l2, timeUnit);
            long l5 = TimeUnit.NANOSECONDS.convert(l3, timeUnit);
            RunnableTaskEntry runnableTaskEntry = new RunnableTaskEntry(runnable, l4, l5, true);
            Object object = timeUpdateMonitor;
            synchronized (object) {
                this.taskEntries.add(runnableTaskEntry);
                timeUpdateMonitor.notifyAll();
            }
        }

        public void shutdown() {
            if (useActualTime) {
                this.actualExecutor.shutdownNow();
                return;
            }
            this.internalExecutorThread.terminate();
        }

        static class CompareRunnableTaskEntryByStartTime
        implements Comparator<RunnableTaskEntry> {
            CompareRunnableTaskEntryByStartTime() {
            }

            @Override
            public int compare(RunnableTaskEntry runnableTaskEntry, RunnableTaskEntry runnableTaskEntry2) {
                long l2 = runnableTaskEntry.startTime;
                long l3 = runnableTaskEntry2.startTime;
                return l2 > l3 ? 1 : (l2 < l3 ? -1 : 0);
            }
        }

        private static class RunnableTaskEntry {
            long startTime;
            Runnable command;
            long period;
            long initialStartTime;
            long executionCount;
            boolean fixedRate;

            RunnableTaskEntry(Runnable runnable, long l2, long l3, boolean bl2) {
                this.command = runnable;
                this.startTime = l2;
                this.initialStartTime = l2;
                this.period = l3;
                this.fixedRate = bl2;
            }

            boolean shouldReschedule() {
                return this.period != 0L;
            }

            public long getStartTime() {
                return this.startTime;
            }

            public Runnable getCommand() {
                return this.command;
            }

            public void setNewStartTime(long l2) {
                if (this.period == 0L) {
                    throw new IllegalStateException("should nto try to reschedule an entry that has no interval or rare");
                }
                if (!this.fixedRate) {
                    this.startTime = l2 + this.period;
                } else {
                    ++this.executionCount;
                    this.startTime = this.initialStartTime + this.executionCount * this.period;
                }
            }
        }

        private class MyExecutorThread
        extends Thread {
            volatile boolean doRun = true;

            private MyExecutorThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void terminate() {
                Object object = timeUpdateMonitor;
                synchronized (object) {
                    this.doRun = false;
                    timeUpdateMonitor.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                ScopeAggregator scopeAggregator = GlobalScopeProvider.enterScope();
                try {
                    try {
                        while (this.doRun) {
                            Object object = timeUpdateMonitor;
                            synchronized (object) {
                                RunnableTaskEntry runnableTaskEntry = ScheduledExecutor.this.taskEntries.peek();
                                while (runnableTaskEntry != null && runnableTaskEntry.getStartTime() < currentTime) {
                                    runnableTaskEntry.getCommand().run();
                                    if (runnableTaskEntry.shouldReschedule()) {
                                        runnableTaskEntry.setNewStartTime(currentTime);
                                        ScheduledExecutor.this.taskEntries.add(runnableTaskEntry);
                                    }
                                    runnableTaskEntry = ScheduledExecutor.this.taskEntries.peek();
                                }
                                timeUpdateMonitor.wait();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (CancellationException cancellationException) {
                        // empty catch block
                    }
                    scopeAggregator.leaveScope();
                    return;
                }
                catch (Throwable throwable) {
                    scopeAggregator.leaveScope();
                    throw throwable;
                }
            }
        }
    }
}

