/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.io.comparator;

import com.contrastsecurity.thirdparty.org.apache.commons.io.comparator.AbstractFileComparator;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;

public class CompositeFileComparator
extends AbstractFileComparator
implements Serializable {
    private static final long serialVersionUID = -2224170307287243428L;
    private static final Comparator<?>[] NO_COMPARATORS = new Comparator[0];
    private final Comparator<File>[] delegates;

    public CompositeFileComparator(Comparator<File> ... comparatorArray) {
        if (comparatorArray == null) {
            this.delegates = NO_COMPARATORS;
        } else {
            this.delegates = new Comparator[comparatorArray.length];
            System.arraycopy(comparatorArray, 0, this.delegates, 0, comparatorArray.length);
        }
    }

    public CompositeFileComparator(Iterable<Comparator<File>> iterable) {
        if (iterable == null) {
            this.delegates = NO_COMPARATORS;
        } else {
            ArrayList<Comparator<File>> arrayList = new ArrayList<Comparator<File>>();
            for (Comparator<File> comparator : iterable) {
                arrayList.add(comparator);
            }
            this.delegates = arrayList.toArray(new Comparator[arrayList.size()]);
        }
    }

    @Override
    public int compare(File file, File file2) {
        Comparator<File> comparator;
        int n2 = 0;
        Comparator<File>[] comparatorArray = this.delegates;
        int n3 = comparatorArray.length;
        for (int i2 = 0; i2 < n3 && (n2 = (comparator = comparatorArray[i2]).compare(file, file2)) == 0; ++i2) {
        }
        return n2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append('{');
        for (int i2 = 0; i2 < this.delegates.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.delegates[i2]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

