/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang;

import com.contrastsecurity.thirdparty.org.apache.commons.lang.text.StrBuilder;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CharRange
implements Serializable {
    private static final long serialVersionUID = 8270183163158333422L;
    private final char start;
    private final char end;
    private final boolean negated;
    private transient String iToString;

    public static CharRange is(char c2) {
        return new CharRange(c2, c2, false);
    }

    public static CharRange isNot(char c2) {
        return new CharRange(c2, c2, true);
    }

    public static CharRange isIn(char c2, char c3) {
        return new CharRange(c2, c3, false);
    }

    public static CharRange isNotIn(char c2, char c3) {
        return new CharRange(c2, c3, true);
    }

    public CharRange(char c2) {
        this(c2, c2, false);
    }

    public CharRange(char c2, boolean bl2) {
        this(c2, c2, bl2);
    }

    public CharRange(char c2, char c3) {
        this(c2, c3, false);
    }

    public CharRange(char c2, char c3, boolean bl2) {
        if (c2 > c3) {
            char c4 = c2;
            c2 = c3;
            c3 = c4;
        }
        this.start = c2;
        this.end = c3;
        this.negated = bl2;
    }

    public char getStart() {
        return this.start;
    }

    public char getEnd() {
        return this.end;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public boolean contains(char c2) {
        return (c2 >= this.start && c2 <= this.end) != this.negated;
    }

    public boolean contains(CharRange charRange) {
        if (charRange == null) {
            throw new IllegalArgumentException("The Range must not be null");
        }
        if (this.negated) {
            if (charRange.negated) {
                return this.start >= charRange.start && this.end <= charRange.end;
            }
            return charRange.end < this.start || charRange.start > this.end;
        }
        if (charRange.negated) {
            return this.start == '\u0000' && this.end == '\uffff';
        }
        return this.start <= charRange.start && this.end >= charRange.end;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CharRange)) {
            return false;
        }
        CharRange charRange = (CharRange)object;
        return this.start == charRange.start && this.end == charRange.end && this.negated == charRange.negated;
    }

    public int hashCode() {
        return 83 + this.start + 7 * this.end + (this.negated ? 1 : 0);
    }

    public String toString() {
        if (this.iToString == null) {
            StrBuilder strBuilder = new StrBuilder(4);
            if (this.isNegated()) {
                strBuilder.append('^');
            }
            strBuilder.append(this.start);
            if (this.start != this.end) {
                strBuilder.append('-');
                strBuilder.append(this.end);
            }
            this.iToString = strBuilder.toString();
        }
        return this.iToString;
    }

    public Iterator iterator() {
        return new CharacterIterator(this, null);
    }

    static boolean access$100(CharRange charRange) {
        return charRange.negated;
    }

    static char access$200(CharRange charRange) {
        return charRange.start;
    }

    static char access$300(CharRange charRange) {
        return charRange.end;
    }

    static class 1 {
    }

    private static class CharacterIterator
    implements Iterator {
        private char current;
        private final CharRange range;
        private boolean hasNext;

        private CharacterIterator(CharRange charRange) {
            this.range = charRange;
            this.hasNext = true;
            if (CharRange.access$100(this.range)) {
                if (CharRange.access$200(this.range) == '\u0000') {
                    if (CharRange.access$300(this.range) == '\uffff') {
                        this.hasNext = false;
                    } else {
                        this.current = (char)(CharRange.access$300(this.range) + '\u0001');
                    }
                } else {
                    this.current = '\u0000';
                }
            } else {
                this.current = CharRange.access$200(this.range);
            }
        }

        private void prepareNext() {
            if (CharRange.access$100(this.range)) {
                if (this.current == '\uffff') {
                    this.hasNext = false;
                } else if (this.current + '\u0001' == CharRange.access$200(this.range)) {
                    if (CharRange.access$300(this.range) == '\uffff') {
                        this.hasNext = false;
                    } else {
                        this.current = (char)(CharRange.access$300(this.range) + '\u0001');
                    }
                } else {
                    this.current = (char)(this.current + '\u0001');
                }
            } else if (this.current < CharRange.access$300(this.range)) {
                this.current = (char)(this.current + '\u0001');
            } else {
                this.hasNext = false;
            }
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Object next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            char c2 = this.current;
            this.prepareNext();
            return new Character(c2);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        CharacterIterator(CharRange charRange, 1 var2_2) {
            this(charRange);
        }
    }
}

