/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang.math;

import java.util.Random;

public final class JVMRandom
extends Random {
    private static final long serialVersionUID = 1L;
    private static final Random SHARED_RANDOM = new Random();
    private boolean constructed = true;

    public synchronized void setSeed(long l2) {
        if (this.constructed) {
            throw new UnsupportedOperationException();
        }
    }

    public synchronized double nextGaussian() {
        throw new UnsupportedOperationException();
    }

    public void nextBytes(byte[] byArray) {
        throw new UnsupportedOperationException();
    }

    public int nextInt() {
        return this.nextInt(Integer.MAX_VALUE);
    }

    public int nextInt(int n2) {
        return SHARED_RANDOM.nextInt(n2);
    }

    public long nextLong() {
        return JVMRandom.nextLong(Long.MAX_VALUE);
    }

    public static long nextLong(long l2) {
        long l3;
        long l4;
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Upper bound for nextInt must be positive");
        }
        if ((l2 & -l2) == l2) {
            return JVMRandom.next63bits() >> 63 - JVMRandom.bitsRequired(l2 - 1L);
        }
        while ((l4 = JVMRandom.next63bits()) - (l3 = l4 % l2) + (l2 - 1L) < 0L) {
        }
        return l3;
    }

    public boolean nextBoolean() {
        return SHARED_RANDOM.nextBoolean();
    }

    public float nextFloat() {
        return SHARED_RANDOM.nextFloat();
    }

    public double nextDouble() {
        return SHARED_RANDOM.nextDouble();
    }

    private static long next63bits() {
        return SHARED_RANDOM.nextLong() & Long.MAX_VALUE;
    }

    private static int bitsRequired(long l2) {
        long l3 = l2;
        int n2 = 0;
        while (l2 >= 0L) {
            if (l3 == 0L) {
                return n2;
            }
            ++n2;
            l2 <<= 1;
            l3 >>= 1;
        }
        return 64 - n2;
    }
}

