/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang.time;

import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.text.StrBuilder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DurationFormatUtils {
    public static final String ISO_EXTENDED_FORMAT_PATTERN = "'P'yyyy'Y'M'M'd'DT'H'H'm'M's.S'S'";
    static final Object y = "y";
    static final Object M = "M";
    static final Object d = "d";
    static final Object H = "H";
    static final Object m = "m";
    static final Object s = "s";
    static final Object S = "S";

    public static String formatDurationHMS(long l2) {
        return DurationFormatUtils.formatDuration(l2, "H:mm:ss.SSS");
    }

    public static String formatDurationISO(long l2) {
        return DurationFormatUtils.formatDuration(l2, ISO_EXTENDED_FORMAT_PATTERN, false);
    }

    public static String formatDuration(long l2, String string) {
        return DurationFormatUtils.formatDuration(l2, string, true);
    }

    public static String formatDuration(long l2, String string, boolean bl2) {
        Token[] tokenArray = DurationFormatUtils.lexx(string);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (Token.containsTokenWithValue(tokenArray, d)) {
            n2 = (int)(l2 / 86400000L);
            l2 -= (long)n2 * 86400000L;
        }
        if (Token.containsTokenWithValue(tokenArray, H)) {
            n3 = (int)(l2 / 3600000L);
            l2 -= (long)n3 * 3600000L;
        }
        if (Token.containsTokenWithValue(tokenArray, m)) {
            n4 = (int)(l2 / 60000L);
            l2 -= (long)n4 * 60000L;
        }
        if (Token.containsTokenWithValue(tokenArray, s)) {
            n5 = (int)(l2 / 1000L);
            l2 -= (long)n5 * 1000L;
        }
        if (Token.containsTokenWithValue(tokenArray, S)) {
            n6 = (int)l2;
        }
        return DurationFormatUtils.format(tokenArray, 0, 0, n2, n3, n4, n5, n6, bl2);
    }

    public static String formatDurationWords(long l2, boolean bl2, boolean bl3) {
        String string;
        String string2 = DurationFormatUtils.formatDuration(l2, "d' days 'H' hours 'm' minutes 's' seconds'");
        if (bl2) {
            string2 = " " + string2;
            string = StringUtils.replaceOnce(string2, " 0 days", "");
            if (string.length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 hours", "")).length() != string2.length()) {
                string2 = string;
                string2 = string = StringUtils.replaceOnce(string2, " 0 minutes", "");
                if (string.length() != string2.length()) {
                    string2 = StringUtils.replaceOnce(string, " 0 seconds", "");
                }
            }
            if (string2.length() != 0) {
                string2 = string2.substring(1);
            }
        }
        if (bl3 && (string = StringUtils.replaceOnce(string2, " 0 seconds", "")).length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 minutes", "")).length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 hours", "")).length() != string2.length()) {
            string2 = StringUtils.replaceOnce(string, " 0 days", "");
        }
        string2 = " " + string2;
        string2 = StringUtils.replaceOnce(string2, " 1 seconds", " 1 second");
        string2 = StringUtils.replaceOnce(string2, " 1 minutes", " 1 minute");
        string2 = StringUtils.replaceOnce(string2, " 1 hours", " 1 hour");
        string2 = StringUtils.replaceOnce(string2, " 1 days", " 1 day");
        return string2.trim();
    }

    public static String formatPeriodISO(long l2, long l3) {
        return DurationFormatUtils.formatPeriod(l2, l3, ISO_EXTENDED_FORMAT_PATTERN, false, TimeZone.getDefault());
    }

    public static String formatPeriod(long l2, long l3, String string) {
        return DurationFormatUtils.formatPeriod(l2, l3, string, true, TimeZone.getDefault());
    }

    public static String formatPeriod(long l2, long l3, String string, boolean bl2, TimeZone timeZone) {
        Token[] tokenArray = DurationFormatUtils.lexx(string);
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(new Date(l2));
        Calendar calendar2 = Calendar.getInstance(timeZone);
        calendar2.setTime(new Date(l3));
        int n2 = calendar2.get(14) - calendar.get(14);
        int n3 = calendar2.get(13) - calendar.get(13);
        int n4 = calendar2.get(12) - calendar.get(12);
        int n5 = calendar2.get(11) - calendar.get(11);
        int n6 = calendar2.get(5) - calendar.get(5);
        int n7 = calendar2.get(2) - calendar.get(2);
        int n8 = calendar2.get(1) - calendar.get(1);
        while (n2 < 0) {
            n2 += 1000;
            --n3;
        }
        while (n3 < 0) {
            n3 += 60;
            --n4;
        }
        while (n4 < 0) {
            n4 += 60;
            --n5;
        }
        while (n5 < 0) {
            n5 += 24;
            --n6;
        }
        if (Token.containsTokenWithValue(tokenArray, M)) {
            while (n6 < 0) {
                n6 += calendar.getActualMaximum(5);
                --n7;
                calendar.add(2, 1);
            }
            while (n7 < 0) {
                n7 += 12;
                --n8;
            }
            if (!Token.containsTokenWithValue(tokenArray, y) && n8 != 0) {
                while (n8 != 0) {
                    n7 += 12 * n8;
                    n8 = 0;
                }
            }
        } else {
            if (!Token.containsTokenWithValue(tokenArray, y)) {
                int n9 = calendar2.get(1);
                if (n7 < 0) {
                    --n9;
                }
                while (calendar.get(1) != n9) {
                    n6 += calendar.getActualMaximum(6) - calendar.get(6);
                    if (calendar instanceof GregorianCalendar && calendar.get(2) == 1 && calendar.get(5) == 29) {
                        ++n6;
                    }
                    calendar.add(1, 1);
                    n6 += calendar.get(6);
                }
                n8 = 0;
            }
            while (calendar.get(2) != calendar2.get(2)) {
                n6 += calendar.getActualMaximum(5);
                calendar.add(2, 1);
            }
            n7 = 0;
            while (n6 < 0) {
                n6 += calendar.getActualMaximum(5);
                --n7;
                calendar.add(2, 1);
            }
        }
        if (!Token.containsTokenWithValue(tokenArray, d)) {
            n5 += 24 * n6;
            n6 = 0;
        }
        if (!Token.containsTokenWithValue(tokenArray, H)) {
            n4 += 60 * n5;
            n5 = 0;
        }
        if (!Token.containsTokenWithValue(tokenArray, m)) {
            n3 += 60 * n4;
            n4 = 0;
        }
        if (!Token.containsTokenWithValue(tokenArray, s)) {
            n2 += 1000 * n3;
            n3 = 0;
        }
        return DurationFormatUtils.format(tokenArray, n8, n7, n6, n5, n4, n3, n2, bl2);
    }

    static String format(Token[] tokenArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        StrBuilder strBuilder = new StrBuilder();
        boolean bl3 = false;
        int n9 = tokenArray.length;
        for (int i2 = 0; i2 < n9; ++i2) {
            Token token = tokenArray[i2];
            Object object = token.getValue();
            int n10 = token.getCount();
            if (object instanceof StringBuffer) {
                strBuilder.append(object.toString());
                continue;
            }
            if (object == y) {
                strBuilder.append(bl2 ? StringUtils.leftPad(Integer.toString(n2), n10, '0') : Integer.toString(n2));
                bl3 = false;
                continue;
            }
            if (object == M) {
                strBuilder.append(bl2 ? StringUtils.leftPad(Integer.toString(n3), n10, '0') : Integer.toString(n3));
                bl3 = false;
                continue;
            }
            if (object == d) {
                strBuilder.append(bl2 ? StringUtils.leftPad(Integer.toString(n4), n10, '0') : Integer.toString(n4));
                bl3 = false;
                continue;
            }
            if (object == H) {
                strBuilder.append(bl2 ? StringUtils.leftPad(Integer.toString(n5), n10, '0') : Integer.toString(n5));
                bl3 = false;
                continue;
            }
            if (object == m) {
                strBuilder.append(bl2 ? StringUtils.leftPad(Integer.toString(n6), n10, '0') : Integer.toString(n6));
                bl3 = false;
                continue;
            }
            if (object == s) {
                strBuilder.append(bl2 ? StringUtils.leftPad(Integer.toString(n7), n10, '0') : Integer.toString(n7));
                bl3 = true;
                continue;
            }
            if (object != S) continue;
            if (bl3) {
                String string = bl2 ? StringUtils.leftPad(Integer.toString(n8), n10, '0') : Integer.toString(n8 += 1000);
                strBuilder.append(string.substring(1));
            } else {
                strBuilder.append(bl2 ? StringUtils.leftPad(Integer.toString(n8), n10, '0') : Integer.toString(n8));
            }
            bl3 = false;
        }
        return strBuilder.toString();
    }

    static Token[] lexx(String string) {
        char[] cArray = string.toCharArray();
        ArrayList<Token> arrayList = new ArrayList<Token>(cArray.length);
        boolean bl2 = false;
        StringBuffer stringBuffer = null;
        Token token = null;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            if (bl2 && c2 != '\'') {
                stringBuffer.append(c2);
                continue;
            }
            Object object = null;
            switch (c2) {
                case '\'': {
                    if (bl2) {
                        stringBuffer = null;
                        bl2 = false;
                        break;
                    }
                    stringBuffer = new StringBuffer();
                    arrayList.add(new Token(stringBuffer));
                    bl2 = true;
                    break;
                }
                case 'y': {
                    object = y;
                    break;
                }
                case 'M': {
                    object = M;
                    break;
                }
                case 'd': {
                    object = d;
                    break;
                }
                case 'H': {
                    object = H;
                    break;
                }
                case 'm': {
                    object = m;
                    break;
                }
                case 's': {
                    object = s;
                    break;
                }
                case 'S': {
                    object = S;
                    break;
                }
                default: {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        arrayList.add(new Token(stringBuffer));
                    }
                    stringBuffer.append(c2);
                }
            }
            if (object == null) continue;
            if (token != null && token.getValue() == object) {
                token.increment();
            } else {
                Token token2 = new Token(object);
                arrayList.add(token2);
                token = token2;
            }
            stringBuffer = null;
        }
        return arrayList.toArray(new Token[arrayList.size()]);
    }

    static class Token {
        private Object value;
        private int count;

        static boolean containsTokenWithValue(Token[] tokenArray, Object object) {
            int n2 = tokenArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (tokenArray[i2].getValue() != object) continue;
                return true;
            }
            return false;
        }

        Token(Object object) {
            this.value = object;
            this.count = 1;
        }

        Token(Object object, int n2) {
            this.value = object;
            this.count = n2;
        }

        void increment() {
            ++this.count;
        }

        int getCount() {
            return this.count;
        }

        Object getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object instanceof Token) {
                Token token = (Token)object;
                if (this.value.getClass() != token.value.getClass()) {
                    return false;
                }
                if (this.count != token.count) {
                    return false;
                }
                if (this.value instanceof StringBuffer) {
                    return this.value.toString().equals(token.value.toString());
                }
                if (this.value instanceof Number) {
                    return this.value.equals(token.value);
                }
                return this.value == token.value;
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return StringUtils.repeat(this.value.toString(), this.count);
        }
    }
}

