/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.logging;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.commons.logging.Log;
import com.contrastsecurity.thirdparty.org.apache.commons.logging.impl.NoOpLog;
import java.lang.reflect.Constructor;
import java.util.Hashtable;

public class LogSource {
    protected static Hashtable logs;
    protected static boolean log4jIsAvailable;
    protected static boolean jdk14IsAvailable;
    protected static Constructor logImplctor;

    private LogSource() {
    }

    public static void setLogImplementation(String string) throws LinkageError, NoSuchMethodException, SecurityException, ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{"".getClass()};
            logImplctor = clazz.getConstructor(classArray);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logImplctor = null;
        }
    }

    public static void setLogImplementation(Class clazz) throws LinkageError, ExceptionInInitializerError, NoSuchMethodException, SecurityException {
        Class[] classArray = new Class[]{"".getClass()};
        logImplctor = clazz.getConstructor(classArray);
    }

    public static Log getInstance(String string) {
        Log log = (Log)logs.get(string);
        if (null == log) {
            log = LogSource.makeNewLogInstance(string);
            logs.put(string, log);
        }
        return log;
    }

    public static Log getInstance(Class clazz) {
        return LogSource.getInstance(clazz.getName());
    }

    public static Log makeNewLogInstance(String string) {
        Log log;
        try {
            Object[] objectArray = new Object[]{string};
            log = (Log)logImplctor.newInstance(objectArray);
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            log = null;
        }
        if (null == log) {
            log = new NoOpLog(string);
        }
        return log;
    }

    public static String[] getLogNames() {
        return logs.keySet().toArray(new String[logs.size()]);
    }

    static {
        Throwable throwable;
        Object object;
        logs = new Hashtable();
        log4jIsAvailable = false;
        jdk14IsAvailable = false;
        logImplctor = null;
        try {
            log4jIsAvailable = null != Class.forName("com.contrastsecurity.thirdparty.org.apache.log4j.Logger");
        }
        catch (Throwable throwable2) {
            Throwables.throwIfCritical(throwable2);
            object = throwable2;
            log4jIsAvailable = false;
        }
        try {
            jdk14IsAvailable = null != Class.forName("com.contrastsecurity.agent.logging.log4j2.f") && null != Class.forName("com.contrastsecurity.thirdparty.org.apache.commons.logging.impl.Jdk14Logger");
        }
        catch (Throwable throwable3) {
            Throwables.throwIfCritical(throwable3);
            object = throwable3;
            jdk14IsAvailable = false;
        }
        object = null;
        try {
            object = System.getProperty("com.contrastsecurity.thirdparty.org.apache.commons.logging.log");
            if (object == null) {
                object = System.getProperty("com.contrastsecurity.thirdparty.org.apache.commons.logging.Log");
            }
        }
        catch (Throwable throwable4) {
            Throwables.throwIfCritical(throwable4);
            throwable = throwable4;
        }
        if (object != null) {
            try {
                LogSource.setLogImplementation((String)object);
            }
            catch (Throwable throwable5) {
                Throwables.throwIfCritical(throwable5);
                throwable = throwable5;
                try {
                    LogSource.setLogImplementation("com.contrastsecurity.thirdparty.org.apache.commons.logging.impl.NoOpLog");
                }
                catch (Throwable throwable6) {
                    Throwables.throwIfCritical(throwable6);
                    Throwable throwable7 = throwable6;
                }
            }
        } else {
            try {
                if (log4jIsAvailable) {
                    LogSource.setLogImplementation("com.contrastsecurity.thirdparty.org.apache.commons.logging.impl.Log4JLogger");
                } else if (jdk14IsAvailable) {
                    LogSource.setLogImplementation("com.contrastsecurity.thirdparty.org.apache.commons.logging.impl.Jdk14Logger");
                } else {
                    LogSource.setLogImplementation("com.contrastsecurity.thirdparty.org.apache.commons.logging.impl.NoOpLog");
                }
            }
            catch (Throwable throwable8) {
                Throwables.throwIfCritical(throwable8);
                throwable = throwable8;
                try {
                    LogSource.setLogImplementation("com.contrastsecurity.thirdparty.org.apache.commons.logging.impl.NoOpLog");
                }
                catch (Throwable throwable9) {
                    Throwables.throwIfCritical(throwable9);
                    Throwable throwable10 = throwable9;
                }
            }
        }
    }
}

