/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.http.impl.conn;

import com.contrastsecurity.thirdparty.org.apache.http.HttpException;
import com.contrastsecurity.thirdparty.org.apache.http.HttpHost;
import com.contrastsecurity.thirdparty.org.apache.http.HttpRequest;
import com.contrastsecurity.thirdparty.org.apache.http.conn.params.ConnRouteParams;
import com.contrastsecurity.thirdparty.org.apache.http.conn.routing.HttpRoute;
import com.contrastsecurity.thirdparty.org.apache.http.conn.routing.HttpRoutePlanner;
import com.contrastsecurity.thirdparty.org.apache.http.conn.scheme.Scheme;
import com.contrastsecurity.thirdparty.org.apache.http.conn.scheme.SchemeRegistry;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.HttpContext;
import com.contrastsecurity.thirdparty.org.apache.http.util.Args;
import com.contrastsecurity.thirdparty.org.apache.http.util.Asserts;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

@Deprecated
public class ProxySelectorRoutePlanner
implements HttpRoutePlanner {
    protected final SchemeRegistry schemeRegistry;
    protected ProxySelector proxySelector;

    public ProxySelectorRoutePlanner(SchemeRegistry schemeRegistry, ProxySelector proxySelector) {
        Args.notNull(schemeRegistry, "SchemeRegistry");
        this.schemeRegistry = schemeRegistry;
        this.proxySelector = proxySelector;
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public void setProxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
    }

    @Override
    public HttpRoute determineRoute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        Args.notNull(httpRequest, "HTTP request");
        HttpRoute httpRoute = ConnRouteParams.getForcedRoute(httpRequest.getParams());
        if (httpRoute != null) {
            return httpRoute;
        }
        Asserts.notNull(httpHost, "Target host");
        InetAddress inetAddress = ConnRouteParams.getLocalAddress(httpRequest.getParams());
        HttpHost httpHost2 = this.determineProxy(httpHost, httpRequest, httpContext);
        Scheme scheme = this.schemeRegistry.getScheme(httpHost.getSchemeName());
        boolean bl2 = scheme.isLayered();
        httpRoute = httpHost2 == null ? new HttpRoute(httpHost, inetAddress, bl2) : new HttpRoute(httpHost, inetAddress, httpHost2, bl2);
        return httpRoute;
    }

    protected HttpHost determineProxy(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        ProxySelector proxySelector = this.proxySelector;
        if (proxySelector == null) {
            proxySelector = ProxySelector.getDefault();
        }
        if (proxySelector == null) {
            return null;
        }
        URI uRI = null;
        try {
            uRI = new URI(httpHost.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new HttpException("Cannot convert host to URI: " + httpHost, uRISyntaxException);
        }
        List<Proxy> list = proxySelector.select(uRI);
        Proxy proxy = this.chooseProxy(list, httpHost, httpRequest, httpContext);
        HttpHost httpHost2 = null;
        if (proxy.type() == Proxy.Type.HTTP) {
            if (!(proxy.address() instanceof InetSocketAddress)) {
                throw new HttpException("Unable to handle non-Inet proxy address: " + proxy.address());
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
            httpHost2 = new HttpHost(this.getHost(inetSocketAddress), inetSocketAddress.getPort());
        }
        return httpHost2;
    }

    protected String getHost(InetSocketAddress inetSocketAddress) {
        return inetSocketAddress.isUnresolved() ? inetSocketAddress.getHostName() : inetSocketAddress.getAddress().getHostAddress();
    }

    protected Proxy chooseProxy(List<Proxy> list, HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) {
        Args.notEmpty(list, "List of proxies");
        Proxy proxy = null;
        block3: for (int i2 = 0; proxy == null && i2 < list.size(); ++i2) {
            Proxy proxy2 = list.get(i2);
            switch (proxy2.type()) {
                case DIRECT: 
                case HTTP: {
                    proxy = proxy2;
                    continue block3;
                }
            }
        }
        if (proxy == null) {
            proxy = Proxy.NO_PROXY;
        }
        return proxy;
    }
}

