/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.http.impl.execchain;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.commons.logging.Log;
import com.contrastsecurity.thirdparty.org.apache.commons.logging.LogFactory;
import com.contrastsecurity.thirdparty.org.apache.http.HttpException;
import com.contrastsecurity.thirdparty.org.apache.http.HttpHost;
import com.contrastsecurity.thirdparty.org.apache.http.HttpRequest;
import com.contrastsecurity.thirdparty.org.apache.http.HttpResponse;
import com.contrastsecurity.thirdparty.org.apache.http.ProtocolException;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.Contract;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.org.apache.http.auth.AuthScope;
import com.contrastsecurity.thirdparty.org.apache.http.auth.UsernamePasswordCredentials;
import com.contrastsecurity.thirdparty.org.apache.http.client.CredentialsProvider;
import com.contrastsecurity.thirdparty.org.apache.http.client.methods.CloseableHttpResponse;
import com.contrastsecurity.thirdparty.org.apache.http.client.methods.HttpExecutionAware;
import com.contrastsecurity.thirdparty.org.apache.http.client.methods.HttpRequestWrapper;
import com.contrastsecurity.thirdparty.org.apache.http.client.methods.HttpUriRequest;
import com.contrastsecurity.thirdparty.org.apache.http.client.protocol.HttpClientContext;
import com.contrastsecurity.thirdparty.org.apache.http.client.utils.URIUtils;
import com.contrastsecurity.thirdparty.org.apache.http.conn.routing.HttpRoute;
import com.contrastsecurity.thirdparty.org.apache.http.impl.client.BasicCredentialsProvider;
import com.contrastsecurity.thirdparty.org.apache.http.impl.execchain.ClientExecChain;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.HttpContext;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.HttpProcessor;
import com.contrastsecurity.thirdparty.org.apache.http.util.Args;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ProtocolExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final HttpProcessor httpProcessor;

    public ProtocolExec(ClientExecChain clientExecChain, HttpProcessor httpProcessor) {
        Args.notNull(clientExecChain, "HTTP client request executor");
        Args.notNull(httpProcessor, "HTTP protocol processor");
        this.requestExecutor = clientExecChain;
        this.httpProcessor = httpProcessor;
    }

    void rewriteRequestURI(HttpRequestWrapper httpRequestWrapper, HttpRoute httpRoute, boolean bl2) throws ProtocolException {
        URI uRI = httpRequestWrapper.getURI();
        if (uRI != null) {
            try {
                httpRequestWrapper.setURI(URIUtils.rewriteURIForRoute(uRI, httpRoute, bl2));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ProtocolException("Invalid URI: " + uRI, uRISyntaxException);
            }
        }
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        Object object;
        Object object2;
        Object object3;
        URI uRI;
        block18: {
            Args.notNull(httpRoute, "HTTP route");
            Args.notNull(httpRequestWrapper, "HTTP request");
            Args.notNull(httpClientContext, "HTTP context");
            HttpRequest httpRequest = httpRequestWrapper.getOriginal();
            uRI = null;
            if (httpRequest instanceof HttpUriRequest) {
                uRI = ((HttpUriRequest)httpRequest).getURI();
            } else {
                object3 = httpRequest.getRequestLine().getUri();
                try {
                    uRI = URI.create((String)object3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!this.log.isDebugEnabled()) break block18;
                    this.log.debug("Unable to parse '" + (String)object3 + "' as a valid URI; " + "request URI and Host header may be inconsistent", illegalArgumentException);
                }
            }
        }
        httpRequestWrapper.setURI(uRI);
        this.rewriteRequestURI(httpRequestWrapper, httpRoute, httpClientContext.getRequestConfig().isNormalizeUri());
        object3 = httpRequestWrapper.getParams();
        HttpHost httpHost = (HttpHost)object3.getParameter("http.virtual-host");
        if (httpHost != null && httpHost.getPort() == -1) {
            int n2 = httpRoute.getTargetHost().getPort();
            if (n2 != -1) {
                httpHost = new HttpHost(httpHost.getHostName(), n2, httpHost.getSchemeName());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Using virtual host" + httpHost);
            }
        }
        HttpHost httpHost2 = null;
        if (httpHost != null) {
            httpHost2 = httpHost;
        } else if (uRI != null && uRI.isAbsolute() && uRI.getHost() != null) {
            httpHost2 = new HttpHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
        }
        if (httpHost2 == null) {
            httpHost2 = httpRequestWrapper.getTarget();
        }
        if (httpHost2 == null) {
            httpHost2 = httpRoute.getTargetHost();
        }
        if (uRI != null && (object2 = uRI.getUserInfo()) != null) {
            object = httpClientContext.getCredentialsProvider();
            if (object == null) {
                object = new BasicCredentialsProvider();
                httpClientContext.setCredentialsProvider((CredentialsProvider)object);
            }
            object.setCredentials(new AuthScope(httpHost2), new UsernamePasswordCredentials((String)object2));
        }
        httpClientContext.setAttribute("http.target_host", httpHost2);
        httpClientContext.setAttribute("http.route", httpRoute);
        httpClientContext.setAttribute("http.request", httpRequestWrapper);
        this.httpProcessor.process(httpRequestWrapper, (HttpContext)httpClientContext);
        object2 = this.requestExecutor.execute(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
        try {
            httpClientContext.setAttribute("http.response", object2);
            this.httpProcessor.process((HttpResponse)object2, (HttpContext)httpClientContext);
            return object2;
        }
        catch (RuntimeException runtimeException) {
            Throwables.throwIfCritical(runtimeException);
            object = runtimeException;
            object2.close();
            throw object;
        }
        catch (IOException iOException) {
            object2.close();
            throw iOException;
        }
        catch (HttpException httpException) {
            object2.close();
            throw httpException;
        }
    }
}

