/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rewrite;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.Log4jLogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.KeyValuePair;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.MapMessage;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.Message;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@Plugin(name="MapRewritePolicy", category="Core", elementType="rewritePolicy", printObject=true)
public final class MapRewritePolicy
implements RewritePolicy {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private final Map<String, Object> map;
    private final Mode mode;

    private MapRewritePolicy(Map<String, Object> map, Mode mode) {
        this.map = map;
        this.mode = mode;
    }

    @Override
    public LogEvent rewrite(LogEvent logEvent) {
        Message message = logEvent.getMessage();
        if (message == null || !(message instanceof MapMessage)) {
            return logEvent;
        }
        MapMessage mapMessage = (MapMessage)message;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(mapMessage.getData());
        switch (this.mode) {
            case Add: {
                hashMap.putAll(this.map);
                break;
            }
            default: {
                for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                    if (!hashMap.containsKey(entry.getKey())) continue;
                    hashMap.put(entry.getKey(), entry.getValue());
                }
            }
        }
        Iterator<Map.Entry<String, Object>> iterator = mapMessage.newInstance(hashMap);
        return new Log4jLogEvent.Builder(logEvent).setMessage((Message)((Object)iterator)).build();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("mode=").append((Object)this.mode);
        stringBuilder.append(" {");
        boolean bl2 = true;
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            if (!bl2) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
            bl2 = false;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @PluginFactory
    public static MapRewritePolicy createPolicy(@PluginAttribute(value="mode") String string, @PluginElement(value="KeyValuePair") KeyValuePair[] keyValuePairArray) {
        Mode mode;
        Mode mode2 = mode = string == null ? (mode = Mode.Add) : Mode.valueOf(string);
        if (keyValuePairArray == null || keyValuePairArray.length == 0) {
            LOGGER.error("keys and values must be specified for the MapRewritePolicy");
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (KeyValuePair keyValuePair : keyValuePairArray) {
            String string2 = keyValuePair.getKey();
            if (string2 == null) {
                LOGGER.error("A null key is not valid in MapRewritePolicy");
                continue;
            }
            String string3 = keyValuePair.getValue();
            if (string3 == null) {
                LOGGER.error("A null value for key " + string2 + " is not allowed in MapRewritePolicy");
                continue;
            }
            hashMap.put(keyValuePair.getKey(), keyValuePair.getValue());
        }
        if (hashMap.isEmpty()) {
            LOGGER.error("MapRewritePolicy is not configured with any valid key value pairs");
            return null;
        }
        return new MapRewritePolicy(hashMap, mode);
    }

    public static enum Mode {
        Add,
        Update;

    }
}

