/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.routing;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.AbstractLifeCycle;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.routing.PurgePolicy;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.routing.RoutingAppender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.ConfigurationScheduler;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Scheduled;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@Plugin(name="IdlePurgePolicy", category="Core", printObject=true)
@Scheduled
public class IdlePurgePolicy
extends AbstractLifeCycle
implements PurgePolicy,
Runnable {
    private final long timeToLive;
    private final long checkInterval;
    private final ConcurrentMap<String, Long> appendersUsage = new ConcurrentHashMap<String, Long>();
    private RoutingAppender routingAppender;
    private final ConfigurationScheduler scheduler;
    private volatile ScheduledFuture<?> future;

    public IdlePurgePolicy(long l2, long l3, ConfigurationScheduler configurationScheduler) {
        this.timeToLive = l2;
        this.checkInterval = l3;
        this.scheduler = configurationScheduler;
    }

    @Override
    public void initialize(RoutingAppender routingAppender) {
        this.routingAppender = routingAppender;
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        boolean bl2 = this.stop(this.future);
        this.setStopped();
        return bl2;
    }

    @Override
    public void purge() {
        long l2 = System.currentTimeMillis() - this.timeToLive;
        for (Map.Entry entry : this.appendersUsage.entrySet()) {
            long l3 = (Long)entry.getValue();
            if (l3 >= l2 || !this.appendersUsage.remove(entry.getKey(), l3)) continue;
            LOGGER.debug("Removing appender {}", entry.getKey());
            this.routingAppender.deleteAppender((String)entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(String string, LogEvent logEvent) {
        long l2 = System.currentTimeMillis();
        this.appendersUsage.put(string, l2);
        if (this.future == null) {
            IdlePurgePolicy idlePurgePolicy = this;
            synchronized (idlePurgePolicy) {
                if (this.future == null) {
                    this.scheduleNext();
                }
            }
        }
    }

    @Override
    public void run() {
        this.purge();
        this.scheduleNext();
    }

    private void scheduleNext() {
        long l2 = Long.MAX_VALUE;
        for (Map.Entry entry : this.appendersUsage.entrySet()) {
            if ((Long)entry.getValue() >= l2) continue;
            l2 = (Long)entry.getValue();
        }
        if (l2 < Long.MAX_VALUE) {
            long l3 = this.timeToLive - (System.currentTimeMillis() - l2);
            this.future = this.scheduler.schedule(this, l3, TimeUnit.MILLISECONDS);
        } else {
            this.future = this.scheduler.schedule(this, this.checkInterval, TimeUnit.MILLISECONDS);
        }
    }

    @PluginFactory
    public static PurgePolicy createPurgePolicy(@PluginAttribute(value="timeToLive") String string, @PluginAttribute(value="checkInterval") String string2, @PluginAttribute(value="timeUnit") String string3, @PluginConfiguration Configuration configuration) {
        long l2;
        TimeUnit timeUnit;
        if (string == null) {
            LOGGER.error("A timeToLive value is required");
            return null;
        }
        if (string3 == null) {
            timeUnit = TimeUnit.MINUTES;
        } else {
            try {
                timeUnit = TimeUnit.valueOf(string3.toUpperCase());
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                LOGGER.error("Invalid timeUnit value {}. timeUnit set to MINUTES", (Object)string3, (Object)exception2);
                timeUnit = TimeUnit.MINUTES;
            }
        }
        long l3 = timeUnit.toMillis(Long.parseLong(string));
        if (l3 < 0L) {
            LOGGER.error("timeToLive must be positive. timeToLive set to 0");
            l3 = 0L;
        }
        if (string2 == null) {
            l2 = l3;
        } else {
            l2 = timeUnit.toMillis(Long.parseLong(string2));
            if (l2 < 0L) {
                LOGGER.error("checkInterval must be positive. checkInterval set equal to timeToLive = {}", (Object)l3);
                l2 = l3;
            }
        }
        return new IdlePurgePolicy(l3, l2, configuration.getScheduler());
    }

    public String toString() {
        return "timeToLive=" + this.timeToLive;
    }
}

