/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.util;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Loader;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.osgi.framework.FrameworkUtil;
import com.contrastsecurity.thirdparty.org.osgi.framework.wiring.BundleWiring;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;

public class ResolverUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String VFSZIP = "vfszip";
    private static final String VFS = "vfs";
    private static final String JAR = "jar";
    private static final String BUNDLE_RESOURCE = "bundleresource";
    private final Set<Class<?>> classMatches = new HashSet();
    private final Set<URI> resourceMatches = new HashSet<URI>();
    private ClassLoader classloader;

    public Set<Class<?>> getClasses() {
        return this.classMatches;
    }

    public Set<URI> getResources() {
        return this.resourceMatches;
    }

    public ClassLoader getClassLoader() {
        return this.classloader != null ? this.classloader : (this.classloader = Loader.getClassLoader(ResolverUtil.class, null));
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classloader = classLoader;
    }

    public void find(Test test, String ... stringArray) {
        if (stringArray == null) {
            return;
        }
        for (String string : stringArray) {
            this.findInPackage(test, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void findInPackage(Test test, String string) {
        Enumeration<URL> enumeration;
        string = string.replace('.', '/');
        ClassLoader classLoader = this.getClassLoader();
        try {
            enumeration = classLoader.getResources(string);
        }
        catch (IOException iOException) {
            LOGGER.warn("Could not read package: {}", (Object)string, (Object)iOException);
            return;
        }
        while (enumeration.hasMoreElements()) {
            try {
                Object object;
                Serializable serializable;
                Object object2;
                URL uRL = enumeration.nextElement();
                String string2 = this.extractPath(uRL);
                LOGGER.info("Scanning for classes in '{}' matching criteria {}", (Object)string2, (Object)test);
                if (VFSZIP.equals(uRL.getProtocol())) {
                    object2 = string2.substring(0, string2.length() - string.length() - 2);
                    serializable = new URL(uRL.getProtocol(), uRL.getHost(), (String)object2);
                    object = new JarInputStream(((URL)serializable).openStream());
                    try {
                        this.loadImplementationsInJar(test, string, (String)object2, (JarInputStream)object);
                        continue;
                    }
                    finally {
                        this.close((JarInputStream)object, serializable);
                        continue;
                    }
                }
                if (VFS.equals(uRL.getProtocol())) {
                    InputStream inputStream;
                    block24: {
                        Object object3;
                        object2 = string2.substring(1, string2.length() - string.length() - 2);
                        serializable = new File((String)object2);
                        if (((File)serializable).exists()) {
                            if (((File)serializable).isDirectory()) {
                                this.loadImplementationsInDirectory(test, string, new File((File)serializable, string));
                                continue;
                            }
                            this.loadImplementationsInJar(test, string, (File)serializable);
                            continue;
                        }
                        object = string2.substring(0, string2.length() - string.length() - 2);
                        URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), (String)object);
                        inputStream = uRL2.openStream();
                        Object object4 = null;
                        try {
                            object3 = inputStream instanceof JarInputStream ? (JarInputStream)inputStream : new JarInputStream(inputStream);
                            this.loadImplementationsInJar(test, string, (String)object, (JarInputStream)object3);
                            if (inputStream == null) continue;
                            if (object4 == null) break block24;
                        }
                        catch (Throwable throwable) {
                            try {
                                Throwables.throwIfCritical(throwable);
                                object4 = object3 = throwable;
                                throw object3;
                            }
                            catch (Throwable throwable2) {
                                if (inputStream == null) throw throwable2;
                                if (object4 == null) {
                                    inputStream.close();
                                    throw throwable2;
                                }
                                try {
                                    inputStream.close();
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    Throwables.throwIfCritical(throwable3);
                                    Throwable throwable4 = throwable3;
                                    ((Throwable)object4).addSuppressed(throwable4);
                                    throw throwable2;
                                }
                            }
                        }
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            Throwables.throwIfCritical(throwable);
                            object3 = throwable;
                            ((Throwable)object4).addSuppressed((Throwable)object3);
                        }
                        continue;
                    }
                    inputStream.close();
                    continue;
                }
                if (BUNDLE_RESOURCE.equals(uRL.getProtocol())) {
                    this.loadImplementationsInBundle(test, string);
                    continue;
                }
                if (JAR.equals(uRL.getProtocol())) {
                    this.loadImplementationsInJar(test, string, uRL);
                    continue;
                }
                object2 = new File(string2);
                if (((File)object2).isDirectory()) {
                    this.loadImplementationsInDirectory(test, string, (File)object2);
                    continue;
                }
                this.loadImplementationsInJar(test, string, (File)object2);
            }
            catch (IOException | URISyntaxException exception) {
                LOGGER.warn("Could not read entries", (Throwable)exception);
            }
        }
    }

    String extractPath(URL uRL) throws UnsupportedEncodingException, URISyntaxException {
        int n2;
        String string = uRL.getPath();
        if (string.startsWith("jar:")) {
            string = string.substring(4);
        }
        if (string.startsWith("file:")) {
            string = string.substring(5);
        }
        if ((n2 = string.indexOf(33)) > 0) {
            string = string.substring(0, n2);
        }
        String string2 = uRL.getProtocol();
        List<String> list = Arrays.asList(VFS, VFSZIP, BUNDLE_RESOURCE);
        if (list.contains(string2)) {
            return string;
        }
        String string3 = new URI(string).getPath();
        if (new File(string3).exists()) {
            return string3;
        }
        return URLDecoder.decode(string, StandardCharsets.UTF_8.name());
    }

    private void loadImplementationsInBundle(Test test, String string) {
        BundleWiring bundleWiring = (BundleWiring)FrameworkUtil.getBundle(ResolverUtil.class).adapt(BundleWiring.class);
        Collection collection = bundleWiring.listResources(string, "*.class", 1);
        for (String string2 : collection) {
            this.addIfMatching(test, string2);
        }
    }

    private void loadImplementationsInDirectory(Test test, String string, File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string).append('/').append(file2.getName());
            String string3 = string2 = string == null ? file2.getName() : stringBuilder.toString();
            if (file2.isDirectory()) {
                this.loadImplementationsInDirectory(test, string2, file2);
                continue;
            }
            if (!this.isTestApplicable(test, file2.getName())) continue;
            this.addIfMatching(test, string2);
        }
    }

    private boolean isTestApplicable(Test test, String string) {
        return test.doesMatchResource() || string.endsWith(".class") && test.doesMatchClass();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadImplementationsInJar(Test test, String string, URL uRL) {
        JarURLConnection jarURLConnection = null;
        try {
            JarFile jarFile;
            block13: {
                Object object;
                jarURLConnection = (JarURLConnection)uRL.openConnection();
                if (jarURLConnection == null) {
                    LOGGER.error("Could not establish connection to {}", (Object)uRL.toString());
                    return;
                }
                jarURLConnection.setUseCaches(false);
                jarFile = jarURLConnection.getJarFile();
                Throwable throwable = null;
                try {
                    object = jarFile.entries();
                    while (object.hasMoreElements()) {
                        JarEntry jarEntry = object.nextElement();
                        String string2 = jarEntry.getName();
                        if (jarEntry.isDirectory() || !string2.startsWith(string) || !this.isTestApplicable(test, string2)) continue;
                        this.addIfMatching(test, string2);
                    }
                    if (jarFile == null) return;
                    if (throwable == null) break block13;
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable4;
                        Throwables.throwIfCritical(throwable2);
                        throwable = throwable4 = throwable2;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (jarFile == null) throw throwable5;
                        if (throwable == null) {
                            jarFile.close();
                            throw throwable5;
                        }
                        try {
                            jarFile.close();
                            throw throwable5;
                        }
                        catch (Throwable throwable3) {
                            Throwables.throwIfCritical(throwable3);
                            Throwable throwable7 = throwable3;
                            throwable.addSuppressed(throwable7);
                            throw throwable5;
                        }
                    }
                }
                try {
                    jarFile.close();
                    return;
                }
                catch (Throwable throwable4) {
                    Throwables.throwIfCritical(throwable4);
                    object = throwable4;
                    throwable.addSuppressed((Throwable)object);
                    return;
                }
            }
            jarFile.close();
            return;
        }
        catch (IOException iOException) {
            LOGGER.error("Could not search JAR file '{}' for classes matching criteria {}, file not found", (Object)uRL.toString(), (Object)test, (Object)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImplementationsInJar(Test test, String string, File file) {
        JarInputStream jarInputStream = null;
        try {
            jarInputStream = new JarInputStream(new FileInputStream(file));
            this.loadImplementationsInJar(test, string, file.getPath(), jarInputStream);
            this.close(jarInputStream, file);
        }
        catch (IOException iOException) {
            try {
                LOGGER.error("Could not search JAR file '{}' for classes matching criteria {}, file not found", (Object)file, (Object)test, (Object)iOException);
                this.close(jarInputStream, file);
            }
            catch (Throwable throwable) {
                this.close(jarInputStream, file);
                throw throwable;
            }
        }
    }

    private void close(JarInputStream jarInputStream, Object object) {
        if (jarInputStream != null) {
            try {
                jarInputStream.close();
            }
            catch (IOException iOException) {
                LOGGER.error("Error closing JAR file stream for {}", object, (Object)iOException);
            }
        }
    }

    private void loadImplementationsInJar(Test test, String string, String string2, JarInputStream jarInputStream) {
        try {
            JarEntry jarEntry;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                String string3 = jarEntry.getName();
                if (jarEntry.isDirectory() || !string3.startsWith(string) || !this.isTestApplicable(test, string3)) continue;
                this.addIfMatching(test, string3);
            }
        }
        catch (IOException iOException) {
            LOGGER.error("Could not search JAR file '{}' for classes matching criteria {} due to an IOException", (Object)string2, (Object)test, (Object)iOException);
        }
    }

    protected void addIfMatching(Test test, String string) {
        try {
            Object object;
            ClassLoader classLoader = this.getClassLoader();
            if (test.doesMatchClass()) {
                Class<?> clazz;
                object = string.substring(0, string.indexOf(46)).replace('/', '.');
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Checking to see if class {} matches criteria {}", object, (Object)test);
                }
                if (test.matches(clazz = classLoader.loadClass((String)object))) {
                    this.classMatches.add(clazz);
                }
            }
            if (test.doesMatchResource()) {
                object = classLoader.getResource(string);
                if (object == null) {
                    object = classLoader.getResource(string.substring(1));
                }
                if (object != null && test.matches(((URL)object).toURI())) {
                    this.resourceMatches.add(((URL)object).toURI());
                }
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            LOGGER.warn("Could not examine class {}", (Object)string, (Object)throwable2);
        }
    }

    public static interface Test {
        public boolean matches(Class<?> var1);

        public boolean matches(URI var1);

        public boolean doesMatchClass();

        public boolean doesMatchResource();
    }
}

