/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net;

import com.contrastsecurity.thirdparty.javax.naming.Context;
import com.contrastsecurity.thirdparty.javax.naming.InitialContext;
import com.contrastsecurity.thirdparty.javax.naming.NamingException;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.ManagerFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.JndiCloser;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PropertiesUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class JndiManager
extends AbstractManager {
    private static final JndiManagerFactory FACTORY = new JndiManagerFactory();
    private static final String PREFIX = "com.contrastsecurity.thirdparty.log4j2.enableJndi";
    private static final String JAVA_SCHEME = "java";
    private final InitialContext context;

    private static boolean isJndiEnabled(String string) {
        return PropertiesUtil.getProperties().getBooleanProperty(PREFIX + string, false);
    }

    public static boolean isJndiEnabled() {
        return JndiManager.isJndiContextSelectorEnabled() || JndiManager.isJndiJdbcEnabled() || JndiManager.isJndiJmsEnabled() || JndiManager.isJndiLookupEnabled();
    }

    public static boolean isJndiContextSelectorEnabled() {
        return JndiManager.isJndiEnabled("ContextSelector");
    }

    public static boolean isJndiJdbcEnabled() {
        return JndiManager.isJndiEnabled("Jdbc");
    }

    public static boolean isJndiJmsEnabled() {
        return JndiManager.isJndiEnabled("Jms");
    }

    public static boolean isJndiLookupEnabled() {
        return JndiManager.isJndiEnabled("Lookup");
    }

    private JndiManager(String string, InitialContext initialContext) {
        super(null, string);
        this.context = initialContext;
    }

    public static JndiManager getDefaultManager() {
        return JndiManager.getManager(JndiManager.class.getName(), FACTORY, null);
    }

    public static JndiManager getDefaultManager(String string) {
        return JndiManager.getManager(string, FACTORY, null);
    }

    public static JndiManager getJndiManager(String string, String string2, String string3, String string4, String string5, Properties properties) {
        Properties properties2 = JndiManager.createProperties(string, string2, string3, string4, string5, properties);
        return JndiManager.getManager(JndiManager.createManagerName(), FACTORY, properties2);
    }

    public static JndiManager getJndiManager(Properties properties) {
        return JndiManager.getManager(JndiManager.createManagerName(), FACTORY, properties);
    }

    private static String createManagerName() {
        return JndiManager.class.getName() + '@' + JndiManager.class.hashCode();
    }

    public static Properties createProperties(String string, String string2, String string3, String string4, String string5, Properties properties) {
        if (string == null) {
            return null;
        }
        Properties properties2 = new Properties();
        properties2.setProperty("java.naming.factory.initial", string);
        if (string2 != null) {
            properties2.setProperty("java.naming.provider.url", string2);
        } else {
            LOGGER.warn("The JNDI InitialContextFactory class name [{}] was provided, but there was no associated provider URL. This is likely to cause problems.", (Object)string);
        }
        if (string3 != null) {
            properties2.setProperty("java.naming.factory.url.pkgs", string3);
        }
        if (string4 != null) {
            properties2.setProperty("java.naming.security.principal", string4);
            if (string5 != null) {
                properties2.setProperty("java.naming.security.credentials", string5);
            } else {
                LOGGER.warn("A security principal [{}] was provided, but with no corresponding security credentials.", (Object)string4);
            }
        }
        if (properties != null) {
            properties2.putAll((Map<?, ?>)properties);
        }
        return properties2;
    }

    @Override
    protected boolean releaseSub(long l2, TimeUnit timeUnit) {
        return JndiCloser.closeSilently((Context)this.context);
    }

    public <T> T lookup(String string) throws NamingException {
        if (this.context == null) {
            return null;
        }
        try {
            URI uRI = new URI(string);
            if (uRI.getScheme() == null || uRI.getScheme().equals(JAVA_SCHEME)) {
                return (T)this.context.lookup(string);
            }
            LOGGER.warn("Unsupported JNDI URI - {}", (Object)string);
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.warn("Invalid JNDI URI - {}", (Object)string);
        }
        return null;
    }

    public String toString() {
        return "JndiManager [context=" + this.context + ", count=" + this.count + "]";
    }

    private static class JndiManagerFactory
    implements ManagerFactory<JndiManager, Properties> {
        private JndiManagerFactory() {
        }

        @Override
        public JndiManager createManager(String string, Properties properties) {
            if (!JndiManager.isJndiEnabled()) {
                throw new IllegalStateException(String.format("JNDI must be enabled by setting one of the %s* properties to true", JndiManager.PREFIX));
            }
            try {
                return new JndiManager(string, new InitialContext((Hashtable)properties));
            }
            catch (NamingException namingException) {
                LOGGER.error("Error creating JNDI InitialContext for '{}'.", (Object)string, (Object)namingException);
                return null;
            }
        }
    }
}

