/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.javax.mail.Address;
import com.contrastsecurity.thirdparty.javax.mail.Message;
import com.contrastsecurity.thirdparty.javax.mail.MessagingException;
import com.contrastsecurity.thirdparty.javax.mail.Session;
import com.contrastsecurity.thirdparty.javax.mail.internet.AddressException;
import com.contrastsecurity.thirdparty.javax.mail.internet.InternetAddress;
import com.contrastsecurity.thirdparty.javax.mail.internet.MimeMessage;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder;
import java.nio.charset.StandardCharsets;

public class MimeMessageBuilder
implements Builder<MimeMessage> {
    private final MimeMessage message;

    public MimeMessageBuilder(Session session) {
        this.message = new MimeMessage(session);
    }

    public MimeMessageBuilder setFrom(String string) throws MessagingException {
        InternetAddress internetAddress = MimeMessageBuilder.parseAddress(string);
        if (null != internetAddress) {
            this.message.setFrom((Address)internetAddress);
        } else {
            try {
                this.message.setFrom();
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                this.message.setFrom((Address)((InternetAddress)null));
            }
        }
        return this;
    }

    public MimeMessageBuilder setReplyTo(String string) throws MessagingException {
        InternetAddress[] internetAddressArray = MimeMessageBuilder.parseAddresses(string);
        if (null != internetAddressArray) {
            this.message.setReplyTo((Address[])internetAddressArray);
        }
        return this;
    }

    public MimeMessageBuilder setRecipients(Message.RecipientType recipientType, String string) throws MessagingException {
        InternetAddress[] internetAddressArray = MimeMessageBuilder.parseAddresses(string);
        if (null != internetAddressArray) {
            this.message.setRecipients(recipientType, (Address[])internetAddressArray);
        }
        return this;
    }

    public MimeMessageBuilder setSubject(String string) throws MessagingException {
        if (string != null) {
            this.message.setSubject(string, StandardCharsets.UTF_8.name());
        }
        return this;
    }

    @Deprecated
    public MimeMessage getMimeMessage() {
        return this.build();
    }

    @Override
    public MimeMessage build() {
        return this.message;
    }

    private static InternetAddress parseAddress(String string) throws AddressException {
        return string == null ? null : new InternetAddress(string);
    }

    private static InternetAddress[] parseAddresses(String string) throws AddressException {
        return string == null ? null : InternetAddress.parse((String)string, (boolean)true);
    }
}

