/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Throwables;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Objects;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static <T extends AccessibleObject> boolean isAccessible(T t2) {
        Objects.requireNonNull(t2, "No member provided");
        return Modifier.isPublic(((Member)((Object)t2)).getModifiers()) && Modifier.isPublic(((Member)((Object)t2)).getDeclaringClass().getModifiers());
    }

    public static <T extends AccessibleObject> void makeAccessible(T t2) {
        if (!ReflectionUtil.isAccessible(t2) && !t2.isAccessible()) {
            t2.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        Objects.requireNonNull(field, "No field provided");
        if (!(ReflectionUtil.isAccessible(field) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static Object getFieldValue(Field field, Object object) {
        ReflectionUtil.makeAccessible(field);
        if (!Modifier.isStatic(field.getModifiers())) {
            Objects.requireNonNull(object, "No instance given for non-static field");
        }
        try {
            return field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException(illegalAccessException);
        }
    }

    public static Object getStaticFieldValue(Field field) {
        return ReflectionUtil.getFieldValue(field, null);
    }

    public static void setFieldValue(Field field, Object object, Object object2) {
        ReflectionUtil.makeAccessible(field);
        if (!Modifier.isStatic(field.getModifiers())) {
            Objects.requireNonNull(object, "No instance given for non-static field");
        }
        try {
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException(illegalAccessException);
        }
    }

    public static void setStaticFieldValue(Field field, Object object) {
        ReflectionUtil.setFieldValue(field, null, object);
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> clazz) {
        Objects.requireNonNull(clazz, "No class provided");
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            ReflectionUtil.makeAccessible(constructor);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Constructor<T> constructor = clazz.getConstructor(new Class[0]);
                ReflectionUtil.makeAccessible(constructor);
                return constructor;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new IllegalStateException(noSuchMethodException2);
            }
        }
    }

    public static <T> T instantiate(Class<T> clazz) {
        Objects.requireNonNull(clazz, "No class provided");
        Constructor<T> constructor = ReflectionUtil.getDefaultConstructor(clazz);
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException | LinkageError throwable) {
            throw new IllegalArgumentException(throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            com.contrastsecurity.agent.commons.Throwables.throwIfCritical(invocationTargetException);
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            Throwables.rethrow(invocationTargetException2.getCause());
            throw new InternalError("Unreachable");
        }
    }
}

