/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.AbstractLifeCycle;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.ConfigurationFileWatcher;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.ConfigurationScheduler;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.FileWatcher;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Source;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.WatchEventService;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Watcher;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.WrappedFileWatcher;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.ServiceLoaderUtil;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class WatchManager
extends AbstractLifeCycle {
    private static Logger logger = StatusLogger.getLogger();
    private final ConcurrentMap<Source, ConfigurationMonitor> watchers = new ConcurrentHashMap<Source, ConfigurationMonitor>();
    private int intervalSeconds = 0;
    private ScheduledFuture<?> future;
    private final ConfigurationScheduler scheduler;
    private final List<WatchEventService> eventServiceList;
    private final UUID id = LocalUUID.get();

    public WatchManager(ConfigurationScheduler configurationScheduler) {
        this.scheduler = Objects.requireNonNull(configurationScheduler, "scheduler");
        this.eventServiceList = ServiceLoaderUtil.loadServices(WatchEventService.class, MethodHandles.lookup(), true).collect(Collectors.toList());
    }

    public void checkFiles() {
        new WatchRunnable().run();
    }

    public Map<Source, Watcher> getConfigurationWatchers() {
        HashMap<Source, Watcher> hashMap = new HashMap<Source, Watcher>(this.watchers.size());
        for (Map.Entry entry : this.watchers.entrySet()) {
            hashMap.put((Source)entry.getKey(), ((ConfigurationMonitor)entry.getValue()).getWatcher());
        }
        return hashMap;
    }

    public UUID getId() {
        return this.id;
    }

    public int getIntervalSeconds() {
        return this.intervalSeconds;
    }

    @Deprecated
    public Map<File, FileWatcher> getWatchers() {
        HashMap<File, FileWatcher> hashMap = new HashMap<File, FileWatcher>(this.watchers.size());
        for (Map.Entry entry : this.watchers.entrySet()) {
            if (((ConfigurationMonitor)entry.getValue()).getWatcher() instanceof ConfigurationFileWatcher) {
                hashMap.put(((Source)entry.getKey()).getFile(), (FileWatcher)((Object)((ConfigurationMonitor)entry.getValue()).getWatcher()));
                continue;
            }
            hashMap.put(((Source)entry.getKey()).getFile(), new WrappedFileWatcher((FileWatcher)((Object)((ConfigurationMonitor)entry.getValue()).getWatcher())));
        }
        return hashMap;
    }

    public boolean hasEventListeners() {
        return this.eventServiceList.size() > 0;
    }

    private String millisToString(long l2) {
        return new Date(l2).toString();
    }

    public void reset() {
        logger.debug("Resetting {}", (Object)this);
        for (Source source : this.watchers.keySet()) {
            this.reset(source);
        }
    }

    public void reset(File file) {
        if (file == null) {
            return;
        }
        Source source = new Source(file);
        this.reset(source);
    }

    public void reset(Source source) {
        Watcher watcher;
        if (source == null) {
            return;
        }
        ConfigurationMonitor configurationMonitor = (ConfigurationMonitor)this.watchers.get(source);
        if (configurationMonitor != null && (watcher = configurationMonitor.getWatcher()).isModified()) {
            long l2 = watcher.getLastModified();
            if (logger.isDebugEnabled()) {
                logger.debug("Resetting file monitor for '{}' from {} ({}) to {} ({})", (Object)source.getLocation(), (Object)this.millisToString(configurationMonitor.lastModifiedMillis), (Object)configurationMonitor.lastModifiedMillis, (Object)this.millisToString(l2), (Object)l2);
            }
            configurationMonitor.setLastModifiedMillis(l2);
        }
    }

    public void setIntervalSeconds(int n2) {
        if (!this.isStarted()) {
            if (this.intervalSeconds > 0 && n2 == 0) {
                this.scheduler.decrementScheduledItems();
            } else if (this.intervalSeconds == 0 && n2 > 0) {
                this.scheduler.incrementScheduledItems();
            }
            this.intervalSeconds = n2;
        }
    }

    @Override
    public void start() {
        super.start();
        if (this.intervalSeconds > 0) {
            this.future = this.scheduler.scheduleWithFixedDelay(new WatchRunnable(), this.intervalSeconds, this.intervalSeconds, TimeUnit.SECONDS);
        }
        for (WatchEventService watchEventService : this.eventServiceList) {
            watchEventService.subscribe(this);
        }
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        for (WatchEventService watchEventService : this.eventServiceList) {
            watchEventService.unsubscribe(this);
        }
        boolean bl2 = this.stop(this.future);
        this.setStopped();
        return bl2;
    }

    public String toString() {
        return "WatchManager [intervalSeconds=" + this.intervalSeconds + ", watchers=" + this.watchers + ", scheduler=" + this.scheduler + ", future=" + this.future + "]";
    }

    public void unwatch(Source source) {
        logger.debug("Unwatching configuration {}", (Object)source);
        this.watchers.remove(source);
    }

    public void unwatchFile(File file) {
        Source source = new Source(file);
        this.unwatch(source);
    }

    public void watch(Source source, Watcher watcher) {
        watcher.watching(source);
        long l2 = watcher.getLastModified();
        if (logger.isDebugEnabled()) {
            logger.debug("Watching configuration '{}' for lastModified {} ({})", (Object)source, (Object)this.millisToString(l2), (Object)l2);
        }
        this.watchers.put(source, new ConfigurationMonitor(l2, watcher));
    }

    public void watchFile(File file, FileWatcher fileWatcher) {
        Watcher watcher = fileWatcher instanceof Watcher ? (Watcher)((Object)fileWatcher) : new WrappedFileWatcher(fileWatcher);
        Source source = new Source(file);
        this.watch(source, watcher);
    }

    private final class WatchRunnable
    implements Runnable {
        private final String SIMPLE_NAME = WatchRunnable.class.getSimpleName();

        private WatchRunnable() {
        }

        @Override
        public void run() {
            logger.trace("{} run triggered.", (Object)this.SIMPLE_NAME);
            for (Map.Entry entry : WatchManager.this.watchers.entrySet()) {
                Source source = (Source)entry.getKey();
                ConfigurationMonitor configurationMonitor = (ConfigurationMonitor)entry.getValue();
                if (!configurationMonitor.getWatcher().isModified()) continue;
                long l2 = configurationMonitor.getWatcher().getLastModified();
                if (logger.isInfoEnabled()) {
                    logger.info("Source '{}' was modified on {} ({}), previous modification was on {} ({})", (Object)source, (Object)WatchManager.this.millisToString(l2), (Object)l2, (Object)WatchManager.this.millisToString(configurationMonitor.lastModifiedMillis), (Object)configurationMonitor.lastModifiedMillis);
                }
                configurationMonitor.lastModifiedMillis = l2;
                configurationMonitor.getWatcher().modified();
            }
            logger.trace("{} run ended.", (Object)this.SIMPLE_NAME);
        }
    }

    private static class LocalUUID {
        private static final long LOW_MASK = 0xFFFFFFFFL;
        private static final long MID_MASK = 0xFFFF00000000L;
        private static final long HIGH_MASK = 0xFFF000000000000L;
        private static final int NODE_SIZE = 8;
        private static final int SHIFT_2 = 16;
        private static final int SHIFT_4 = 32;
        private static final int SHIFT_6 = 48;
        private static final int HUNDRED_NANOS_PER_MILLI = 10000;
        private static final long NUM_100NS_INTERVALS_SINCE_UUID_EPOCH = 122192928000000000L;
        private static final AtomicInteger COUNT = new AtomicInteger(0);
        private static final long TYPE1 = 4096L;
        private static final byte VARIANT = -128;
        private static final int SEQUENCE_MASK = 16383;

        private LocalUUID() {
        }

        public static UUID get() {
            long l2 = System.currentTimeMillis() * 10000L + 122192928000000000L + (long)(COUNT.incrementAndGet() % 10000);
            long l3 = (l2 & 0xFFFFFFFFL) << 32;
            long l4 = (l2 & 0xFFFF00000000L) >> 16;
            long l5 = (l2 & 0xFFF000000000000L) >> 48;
            long l6 = l3 | l4 | 0x1000L | l5;
            return new UUID(l6, COUNT.incrementAndGet());
        }
    }

    private final class ConfigurationMonitor {
        private final Watcher watcher;
        private volatile long lastModifiedMillis;

        public ConfigurationMonitor(long l2, Watcher watcher) {
            this.watcher = watcher;
            this.lastModifiedMillis = l2;
        }

        public Watcher getWatcher() {
            return this.watcher;
        }

        private void setLastModifiedMillis(long l2) {
            this.lastModifiedMillis = l2;
        }

        public String toString() {
            return "ConfigurationMonitor [watcher=" + this.watcher + ", lastModifiedMillis=" + this.lastModifiedMillis + "]";
        }
    }
}

