/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.slf4j;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.LogManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.LoggingException;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.AbstractLoggerAdapter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.LoggerContext;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.StackLocatorUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.slf4j.Log4jLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.slf4j.Log4jMarkerFactory;
import com.contrastsecurity.thirdparty.org.slf4j.ILoggerFactory;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import java.util.function.Predicate;

public class Log4jLoggerFactory
extends AbstractLoggerAdapter<Logger>
implements ILoggerFactory {
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    private static final String SLF4J_PACKAGE = "org.slf4j";
    private static final Predicate<Class<?>> CALLER_PREDICATE = clazz -> !AbstractLoggerAdapter.class.equals(clazz) && !clazz.getName().startsWith(SLF4J_PACKAGE);
    private static final String TO_SLF4J_CONTEXT = "com.contrastsecurity.thirdparty.org.apache.logging.slf4j.SLF4JLoggerContext";
    private final Log4jMarkerFactory markerFactory;

    public Log4jLoggerFactory(Log4jMarkerFactory log4jMarkerFactory) {
        this.markerFactory = log4jMarkerFactory;
    }

    @Override
    protected Logger newLogger(String string, LoggerContext loggerContext) {
        String string2 = "ROOT".equals(string) ? "" : string;
        return new Log4jLogger(this.markerFactory, this.validateContext(loggerContext).getLogger(string2), string);
    }

    @Override
    protected LoggerContext getContext() {
        Class<?> clazz = LogManager.getFactory().isClassLoaderDependent() ? StackLocatorUtil.getCallerClass(Log4jLoggerFactory.class, CALLER_PREDICATE) : null;
        LOGGER.trace("Log4jLoggerFactory.getContext() found anchor {}", (Object)clazz);
        return clazz == null ? LogManager.getContext(false) : this.getContext(clazz);
    }

    Log4jMarkerFactory getMarkerFactory() {
        return this.markerFactory;
    }

    private LoggerContext validateContext(LoggerContext loggerContext) {
        if (TO_SLF4J_CONTEXT.equals(loggerContext.getClass().getName())) {
            throw new LoggingException("com.contrastsecurity.thirdparty.log4j-slf4j-impl cannot be present with log4j-to-slf4j");
        }
        return loggerContext;
    }
}

