/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.jctools.queues.atomic;

import com.contrastsecurity.thirdparty.org.jctools.queues.atomic.AtomicQueueUtil;
import com.contrastsecurity.thirdparty.org.jctools.queues.atomic.MpscChunkedAtomicArrayQueue;
import com.contrastsecurity.thirdparty.org.jctools.util.Pow2;
import com.contrastsecurity.thirdparty.org.jctools.util.RangeUtil;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class MpscGrowableAtomicArrayQueue<E>
extends MpscChunkedAtomicArrayQueue<E> {
    public MpscGrowableAtomicArrayQueue(int n2) {
        super(Math.max(2, Pow2.roundToPowerOfTwo(n2 / 8)), n2);
    }

    public MpscGrowableAtomicArrayQueue(int n2, int n3) {
        super(n2, n3);
    }

    @Override
    protected int getNextBufferSize(AtomicReferenceArray<E> atomicReferenceArray) {
        long l2 = this.maxQueueCapacity / 2L;
        RangeUtil.checkLessThanOrEqual(AtomicQueueUtil.length(atomicReferenceArray), l2, "buffer.length");
        int n2 = 2 * (AtomicQueueUtil.length(atomicReferenceArray) - 1);
        return n2 + 1;
    }

    @Override
    protected long getCurrentBufferCapacity(long l2) {
        return l2 + 2L == this.maxQueueCapacity ? this.maxQueueCapacity : l2;
    }
}

