/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.jctools.queues.atomic;

import com.contrastsecurity.thirdparty.org.jctools.queues.MessagePassingQueue;
import com.contrastsecurity.thirdparty.org.jctools.queues.atomic.AtomicQueueUtil;
import com.contrastsecurity.thirdparty.org.jctools.queues.atomic.BaseSpscLinkedAtomicArrayQueue;
import com.contrastsecurity.thirdparty.org.jctools.util.Pow2;
import com.contrastsecurity.thirdparty.org.jctools.util.RangeUtil;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class SpscChunkedAtomicArrayQueue<E>
extends BaseSpscLinkedAtomicArrayQueue<E> {
    private final int maxQueueCapacity;
    private long producerQueueLimit;

    public SpscChunkedAtomicArrayQueue(int n2) {
        this(Math.max(8, Pow2.roundToPowerOfTwo(n2 / 8)), n2);
    }

    public SpscChunkedAtomicArrayQueue(int n2, int n3) {
        AtomicReferenceArray atomicReferenceArray;
        RangeUtil.checkGreaterThanOrEqual(n3, 16, "capacity");
        RangeUtil.checkGreaterThanOrEqual(n2, 8, "chunkSize");
        this.maxQueueCapacity = Pow2.roundToPowerOfTwo(n3);
        int n4 = Pow2.roundToPowerOfTwo(n2);
        RangeUtil.checkLessThan(n4, this.maxQueueCapacity, "chunkCapacity");
        long l2 = n4 - 1;
        this.producerBuffer = atomicReferenceArray = AtomicQueueUtil.allocateRefArray(n4 + 1);
        this.producerMask = l2;
        this.consumerBuffer = atomicReferenceArray;
        this.consumerMask = l2;
        this.producerBufferLimit = l2 - 1L;
        this.producerQueueLimit = this.maxQueueCapacity;
    }

    @Override
    final boolean offerColdPath(AtomicReferenceArray<E> atomicReferenceArray, long l2, long l3, int n2, E e2, MessagePassingQueue.Supplier<? extends E> supplier) {
        long l4 = (l2 + 1L) / 4L;
        long l5 = l3 + l4;
        long l6 = this.producerQueueLimit;
        if (l3 >= l6) {
            long l7 = this.lvConsumerIndex();
            this.producerQueueLimit = l6 = l7 + (long)this.maxQueueCapacity;
            if (l3 >= l6) {
                return false;
            }
        }
        if (l5 - l6 > 0L) {
            l5 = l6;
        }
        if (l5 > l3 + 1L && null == AtomicQueueUtil.lvRefElement(atomicReferenceArray, AtomicQueueUtil.calcCircularRefElementOffset(l5, l2))) {
            this.producerBufferLimit = l5 - 1L;
            this.writeToQueue(atomicReferenceArray, e2 == null ? supplier.get() : e2, l3, n2);
        } else if (null == AtomicQueueUtil.lvRefElement(atomicReferenceArray, AtomicQueueUtil.calcCircularRefElementOffset(l3 + 1L, l2))) {
            this.writeToQueue(atomicReferenceArray, e2 == null ? supplier.get() : e2, l3, n2);
        } else {
            AtomicReferenceArray atomicReferenceArray2;
            this.producerBuffer = atomicReferenceArray2 = AtomicQueueUtil.allocateRefArray((int)(l2 + 2L));
            this.linkOldToNew(l3, atomicReferenceArray, n2, atomicReferenceArray2, n2, e2 == null ? supplier.get() : e2);
        }
        return true;
    }

    @Override
    public int capacity() {
        return this.maxQueueCapacity;
    }
}

