/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent;

import com.contrastsecurity.agent.ContrastStarter;
import com.contrastsecurity.agent.boot.DenylistedProcessCheck;
import com.contrastsecurity.agent.injection.ClassInjector;
import com.contrastsecurity.agent.util.ContrastAgentUtil;
import java.io.File;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ContrastLoaderAgent {
    private static final AtomicBoolean ATTACHED = new AtomicBoolean();
    private static final String BASE_INJECTIONS = "/com/contrastsecurity/agent/lib/contrast-agent-base-injections.jar";

    public static void main(String[] args) {
        File agentJarFile = ContrastAgentUtil.findAgentJar();
        if (agentJarFile == null) {
            System.err.println("The Contrast Agent is missing a required configuration of the `contrast.agent.location` system property. Continuing application startup without Contrast Agent....");
            return;
        }
        ContrastStarter.diagnostics(args, agentJarFile);
    }

    public static void agentmain(String args, Instrumentation inst) {
        ContrastLoaderAgent.premain(args, inst);
    }

    public static void premain(String args, Instrumentation inst) {
        if (ATTACHED.getAndSet(true)) {
            System.err.println("The Contrast Agent is already attached, verify that your VM arguments don't include `-javaagent` twice for the Contrast Agent.");
            return;
        }
        if (DenylistedProcessCheck.isDenied(ContrastLoaderAgent.getStartCommand())) {
            return;
        }
        File agentJarFile = ContrastAgentUtil.findAgentJar();
        if (agentJarFile == null) {
            System.err.println("The Contrast Agent is missing a required configuration of the `contrast.agent.location` system property. Continuing application startup without Contrast Agent....");
            return;
        }
        long premainStart = System.nanoTime();
        long jvmUptime = ContrastLoaderAgent.getJvmUptime();
        try {
            ClassInjector.inject(inst, agentJarFile);
            ContrastStarter.start(args, inst, agentJarFile, premainStart, jvmUptime);
        }
        catch (AccessControlException e2) {
            System.err.println("When using a Java SecurityManager, the Contrast agent requires the java.security.AllPermission. Continuing without Contrast...");
            e2.printStackTrace(System.err);
        }
        catch (Exception e3) {
            e3.printStackTrace(System.err);
            System.err.println("Unexpected error during Contrast Agent initialization. Continuing application startup without Contrast Agent....");
        }
    }

    public static InputStream getBaseInjectionsAsStream() {
        return ContrastLoaderAgent.class.getResourceAsStream(BASE_INJECTIONS);
    }

    private static long getJvmUptime() {
        RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();
        return mxBean != null ? mxBean.getUptime() : 0L;
    }

    private static String getStartCommand() {
        try {
            return System.getSecurityManager() == null ? System.getProperty("sun.java.command") : AccessController.doPrivileged(() -> System.getProperty("sun.java.command"));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private ContrastLoaderAgent() {
    }
}

