/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.commons;

import com.contrastsecurity.agent.DontObfuscate;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

@DontObfuscate
public final class Preconditions {
    public static <T extends Collection<?>> T checkNotEmpty(T t2) {
        Objects.requireNonNull(t2);
        Preconditions.check(!t2.isEmpty(), "collection parameter cannot be empty.");
        return t2;
    }

    public static <T extends Collection<?>> T checkNotEmpty(T t2, String string) {
        Objects.requireNonNull(t2, () -> string + " parameter cannot be null");
        Preconditions.check(!t2.isEmpty(), string + " collection parameter cannot be empty.");
        return t2;
    }

    public static <T extends Map> T checkNotEmpty(T t2) {
        Objects.requireNonNull(t2);
        Preconditions.check(!t2.isEmpty(), "map parameter cannot be empty.");
        return t2;
    }

    public static <T extends Map> T checkNotEmpty(T t2, String string) {
        Objects.requireNonNull(t2, () -> string + " parameter cannot be null");
        Preconditions.check(!t2.isEmpty(), string + " map parameter cannot be empty.");
        return t2;
    }

    public static <T> T[] checkNotEmpty(T[] TArray) {
        Objects.requireNonNull(TArray);
        Preconditions.check(TArray.length > 0, "array parameter cannot be empty.");
        return TArray;
    }

    public static <T> T[] checkNotEmpty(T[] TArray, String string) {
        Objects.requireNonNull(TArray, () -> string + " parameter cannot be null");
        Preconditions.check(TArray.length > 0, string + " array parameter cannot be empty.");
        return TArray;
    }

    public static <T extends CharSequence> T checkNotEmpty(T t2) {
        Objects.requireNonNull(t2);
        Preconditions.check(t2.length() > 0, "string parameter cannot be empty.");
        return t2;
    }

    public static <T extends CharSequence> T checkNotEmpty(T t2, String string) {
        Objects.requireNonNull(t2, () -> string + " parameter cannot be null");
        Preconditions.check(t2.length() > 0, string + " string parameter cannot be empty.");
        return t2;
    }

    public static void check(boolean bl2, String string, Object ... objectArray) {
        if (!bl2) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }

    public static void check(boolean bl2, String string) {
        if (!bl2) {
            throw new IllegalArgumentException(string);
        }
    }

    private Preconditions() {
    }
}

